"""
    MetaFab API

     Complete MetaFab API references and guides can be found at: https://trymetafab.com  # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: metafabproject@gmail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from metafab_python.api_client import ApiClient, Endpoint as _Endpoint
from metafab_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from metafab_python.model.create_shop200_response import CreateShop200Response
from metafab_python.model.create_shop_request import CreateShopRequest
from metafab_python.model.get_shops200_response_inner import GetShops200ResponseInner
from metafab_python.model.set_shop_offer_request import SetShopOfferRequest
from metafab_python.model.shop_offer import ShopOffer
from metafab_python.model.transaction_model import TransactionModel
from metafab_python.model.withdraw_from_shop_request import WithdrawFromShopRequest


class ShopsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_shop_endpoint = _Endpoint(
            settings={
                'response_type': (CreateShop200Response,),
                'auth': [],
                'endpoint_path': '/v1/shops',
                'operation_id': 'create_shop',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_authorization',
                    'x_password',
                    'create_shop_request',
                ],
                'required': [
                    'x_authorization',
                    'x_password',
                    'create_shop_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'create_shop_request':
                        (CreateShopRequest,),
                },
                'attribute_map': {
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'create_shop_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_shop_offer_endpoint = _Endpoint(
            settings={
                'response_type': (ShopOffer,),
                'auth': [],
                'endpoint_path': '/v1/shops/{shopId}/items/{shopOfferId}',
                'operation_id': 'get_shop_offer',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'shop_id',
                    'shop_offer_id',
                ],
                'required': [
                    'shop_id',
                    'shop_offer_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shop_id':
                        (str,),
                    'shop_offer_id':
                        (str,),
                },
                'attribute_map': {
                    'shop_id': 'shopId',
                    'shop_offer_id': 'shopOfferId',
                },
                'location_map': {
                    'shop_id': 'path',
                    'shop_offer_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_shop_offers_endpoint = _Endpoint(
            settings={
                'response_type': ([ShopOffer],),
                'auth': [],
                'endpoint_path': '/v1/shops/{shopId}/offers',
                'operation_id': 'get_shop_offers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'shop_id',
                ],
                'required': [
                    'shop_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shop_id':
                        (str,),
                },
                'attribute_map': {
                    'shop_id': 'shopId',
                },
                'location_map': {
                    'shop_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_shops_endpoint = _Endpoint(
            settings={
                'response_type': ([GetShops200ResponseInner],),
                'auth': [],
                'endpoint_path': '/v1/shops',
                'operation_id': 'get_shops',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_game_key',
                ],
                'required': [
                    'x_game_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_game_key':
                        (str,),
                },
                'attribute_map': {
                    'x_game_key': 'X-Game-Key',
                },
                'location_map': {
                    'x_game_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_shop_offer_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/shops/{shopId}/offers/{shopOfferId}',
                'operation_id': 'remove_shop_offer',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'shop_id',
                    'shop_offer_id',
                    'x_authorization',
                    'x_password',
                ],
                'required': [
                    'shop_id',
                    'shop_offer_id',
                    'x_authorization',
                    'x_password',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shop_id':
                        (str,),
                    'shop_offer_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                },
                'attribute_map': {
                    'shop_id': 'shopId',
                    'shop_offer_id': 'shopOfferId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'shop_id': 'path',
                    'shop_offer_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.set_shop_offer_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/shops/{shopId}/offers',
                'operation_id': 'set_shop_offer',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'shop_id',
                    'x_authorization',
                    'x_password',
                    'set_shop_offer_request',
                ],
                'required': [
                    'shop_id',
                    'x_authorization',
                    'x_password',
                    'set_shop_offer_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shop_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'set_shop_offer_request':
                        (SetShopOfferRequest,),
                },
                'attribute_map': {
                    'shop_id': 'shopId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'shop_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'set_shop_offer_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.use_shop_offer_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/shops/{shopId}/offers/{shopOfferId}/uses',
                'operation_id': 'use_shop_offer',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'shop_id',
                    'shop_offer_id',
                    'x_authorization',
                    'x_password',
                ],
                'required': [
                    'shop_id',
                    'shop_offer_id',
                    'x_authorization',
                    'x_password',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shop_id':
                        (str,),
                    'shop_offer_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                },
                'attribute_map': {
                    'shop_id': 'shopId',
                    'shop_offer_id': 'shopOfferId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'shop_id': 'path',
                    'shop_offer_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.withdraw_from_shop_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/shops/{shopId}/withdrawals',
                'operation_id': 'withdraw_from_shop',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'shop_id',
                    'x_authorization',
                    'x_password',
                    'withdraw_from_shop_request',
                ],
                'required': [
                    'shop_id',
                    'x_authorization',
                    'x_password',
                    'withdraw_from_shop_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'shop_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'withdraw_from_shop_request':
                        (WithdrawFromShopRequest,),
                },
                'attribute_map': {
                    'shop_id': 'shopId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'shop_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'withdraw_from_shop_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_shop(
        self,
        x_authorization,
        x_password,
        create_shop_request,
        **kwargs
    ):
        """Create shop  # noqa: E501

        Creates a new game shop and deploys a shop contract on behalf of the authenticating game's primary wallet. The deployed shop contract allows you to create fixed price rates for players to buy specific items from any item collection or ERC1155 contract. Additionally, a shop allows you to create shop offers for some set of item(s) to another set of item(s) or any mix of currency. Shops completely support gasless player transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_shop(x_authorization, x_password, create_shop_request, async_req=True)
        >>> result = thread.get()

        Args:
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            create_shop_request (CreateShopRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateShop200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['create_shop_request'] = \
            create_shop_request
        return self.create_shop_endpoint.call_with_http_info(**kwargs)

    def get_shop_offer(
        self,
        shop_id,
        shop_offer_id,
        **kwargs
    ):
        """Get shop offer  # noqa: E501

        Returns a shop offer object for the provided shopOfferId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shop_offer(shop_id, shop_offer_id, async_req=True)
        >>> result = thread.get()

        Args:
            shop_id (str): Any shop id within the MetaFab ecosystem.
            shop_offer_id (str): Any offer id for the shop. Zero, or a positive integer.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ShopOffer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['shop_id'] = \
            shop_id
        kwargs['shop_offer_id'] = \
            shop_offer_id
        return self.get_shop_offer_endpoint.call_with_http_info(**kwargs)

    def get_shop_offers(
        self,
        shop_id,
        **kwargs
    ):
        """Get shop offers  # noqa: E501

        Returns all shop offers as an array of shop offer objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shop_offers(shop_id, async_req=True)
        >>> result = thread.get()

        Args:
            shop_id (str): Any shop id within the MetaFab ecosystem.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [ShopOffer]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['shop_id'] = \
            shop_id
        return self.get_shop_offers_endpoint.call_with_http_info(**kwargs)

    def get_shops(
        self,
        x_game_key,
        **kwargs
    ):
        """Get shops  # noqa: E501

        Returns an array of active shops for the game associated with the provided `X-Game-Key`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_shops(x_game_key, async_req=True)
        >>> result = thread.get()

        Args:
            x_game_key (str): The `publishedKey` of a specific game. This can be shared or included in game clients, websites, etc.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [GetShops200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_game_key'] = \
            x_game_key
        return self.get_shops_endpoint.call_with_http_info(**kwargs)

    def remove_shop_offer(
        self,
        shop_id,
        shop_offer_id,
        x_authorization,
        x_password,
        **kwargs
    ):
        """Remove shop offer  # noqa: E501

        Removes the provided offer by offerId from the provided shop. Removed offers can no longer be used.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_shop_offer(shop_id, shop_offer_id, x_authorization, x_password, async_req=True)
        >>> result = thread.get()

        Args:
            shop_id (str): Any shop id within the MetaFab ecosystem.
            shop_offer_id (str): Any offer id for the shop. Zero, or a positive integer.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['shop_id'] = \
            shop_id
        kwargs['shop_offer_id'] = \
            shop_offer_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        return self.remove_shop_offer_endpoint.call_with_http_info(**kwargs)

    def set_shop_offer(
        self,
        shop_id,
        x_authorization,
        x_password,
        set_shop_offer_request,
        **kwargs
    ):
        """Set shop offer  # noqa: E501

        Sets a new shop offer or updates an existing one for the provided id. Shop offers allow currency to item, item to currency or item to item exchanges.  All request fields besides `id` are optional. Any optional fields omitted will not be used for the offer. This allows you to create many different combinations of offers. For example, you can create an offer that may require 3 unique item ids of specified quantities from a given item collection and gives the user 1 new unique item id in exchange.  Another example, you may want to make a shop offer from one ERC20 token to another. This is also possible - simple set the input and output currency fields and leave the others blank.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_shop_offer(shop_id, x_authorization, x_password, set_shop_offer_request, async_req=True)
        >>> result = thread.get()

        Args:
            shop_id (str): Any shop id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            set_shop_offer_request (SetShopOfferRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['shop_id'] = \
            shop_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['set_shop_offer_request'] = \
            set_shop_offer_request
        return self.set_shop_offer_endpoint.call_with_http_info(**kwargs)

    def use_shop_offer(
        self,
        shop_id,
        shop_offer_id,
        x_authorization,
        x_password,
        **kwargs
    ):
        """Use shop offer  # noqa: E501

        Uses a shop offer. The required (input) item(s) and/or currency are removed from the wallet or player wallet using the offer. The given (output) item(s) and/or currency are given to the wallet or player wallet using the offer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.use_shop_offer(shop_id, shop_offer_id, x_authorization, x_password, async_req=True)
        >>> result = thread.get()

        Args:
            shop_id (str): Any shop id within the MetaFab ecosystem.
            shop_offer_id (str): Any offer id for the shop. Zero, or a positive integer.
            x_authorization (str): The `secretKey` of a specific game or the `accessToken` of a specific player.
            x_password (str): The password of the authenticating game or player. Required to decrypt and perform blockchain transactions with the game or player primary wallet.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['shop_id'] = \
            shop_id
        kwargs['shop_offer_id'] = \
            shop_offer_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        return self.use_shop_offer_endpoint.call_with_http_info(**kwargs)

    def withdraw_from_shop(
        self,
        shop_id,
        x_authorization,
        x_password,
        withdraw_from_shop_request,
        **kwargs
    ):
        """Withdraw from shop  # noqa: E501

        Withdraws native token, currency or items from a shop. Whenever a shop offer has input requirements, the native tokens, currencies or items for the requirements of that offer are deposited into the shop contract when the offer is used. These can be withdrawn to any other address.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.withdraw_from_shop(shop_id, x_authorization, x_password, withdraw_from_shop_request, async_req=True)
        >>> result = thread.get()

        Args:
            shop_id (str): Any shop id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            withdraw_from_shop_request (WithdrawFromShopRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['shop_id'] = \
            shop_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['withdraw_from_shop_request'] = \
            withdraw_from_shop_request
        return self.withdraw_from_shop_endpoint.call_with_http_info(**kwargs)

