"""
    MetaFab API

     Complete MetaFab API references and guides can be found at: https://trymetafab.com  # noqa: E501

    The version of the OpenAPI document: 1.4.1
    Contact: metafabproject@gmail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from metafab_python.api_client import ApiClient, Endpoint as _Endpoint
from metafab_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from metafab_python.model.create_lootbox_manager200_response import CreateLootboxManager200Response
from metafab_python.model.create_lootbox_manager_request import CreateLootboxManagerRequest
from metafab_python.model.get_lootbox_managers200_response_inner import GetLootboxManagers200ResponseInner
from metafab_python.model.lootbox_manager_lootbox import LootboxManagerLootbox
from metafab_python.model.set_lootbox_manager_lootbox_request import SetLootboxManagerLootboxRequest
from metafab_python.model.transaction_model import TransactionModel


class LootboxesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_lootbox_manager_endpoint = _Endpoint(
            settings={
                'response_type': (CreateLootboxManager200Response,),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers',
                'operation_id': 'create_lootbox_manager',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_authorization',
                    'x_password',
                    'create_lootbox_manager_request',
                ],
                'required': [
                    'x_authorization',
                    'x_password',
                    'create_lootbox_manager_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'create_lootbox_manager_request':
                        (CreateLootboxManagerRequest,),
                },
                'attribute_map': {
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'create_lootbox_manager_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_lootbox_manager_lootbox_endpoint = _Endpoint(
            settings={
                'response_type': (LootboxManagerLootbox,),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers/{lootboxManagerId}/lootboxes/{lootboxManagerLootboxId}',
                'operation_id': 'get_lootbox_manager_lootbox',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'lootbox_manager_id',
                    'lootbox_manager_lootbox_id',
                ],
                'required': [
                    'lootbox_manager_id',
                    'lootbox_manager_lootbox_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'lootbox_manager_id':
                        (str,),
                    'lootbox_manager_lootbox_id':
                        (str,),
                },
                'attribute_map': {
                    'lootbox_manager_id': 'lootboxManagerId',
                    'lootbox_manager_lootbox_id': 'lootboxManagerLootboxId',
                },
                'location_map': {
                    'lootbox_manager_id': 'path',
                    'lootbox_manager_lootbox_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lootbox_manager_lootboxes_endpoint = _Endpoint(
            settings={
                'response_type': ([LootboxManagerLootbox],),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers/{lootboxManagerId}/lootboxes',
                'operation_id': 'get_lootbox_manager_lootboxes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'lootbox_manager_id',
                ],
                'required': [
                    'lootbox_manager_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'lootbox_manager_id':
                        (str,),
                },
                'attribute_map': {
                    'lootbox_manager_id': 'lootboxManagerId',
                },
                'location_map': {
                    'lootbox_manager_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_lootbox_managers_endpoint = _Endpoint(
            settings={
                'response_type': ([GetLootboxManagers200ResponseInner],),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers',
                'operation_id': 'get_lootbox_managers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_game_key',
                ],
                'required': [
                    'x_game_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_game_key':
                        (str,),
                },
                'attribute_map': {
                    'x_game_key': 'X-Game-Key',
                },
                'location_map': {
                    'x_game_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.open_lootbox_manager_lootbox_endpoint = _Endpoint(
            settings={
                'response_type': ([TransactionModel],),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers/{lootboxManagerId}/lootboxes/{lootboxManagerLootboxId}/opens',
                'operation_id': 'open_lootbox_manager_lootbox',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'lootbox_manager_id',
                    'lootbox_manager_lootbox_id',
                    'x_authorization',
                    'x_password',
                ],
                'required': [
                    'lootbox_manager_id',
                    'lootbox_manager_lootbox_id',
                    'x_authorization',
                    'x_password',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'lootbox_manager_id':
                        (str,),
                    'lootbox_manager_lootbox_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                },
                'attribute_map': {
                    'lootbox_manager_id': 'lootboxManagerId',
                    'lootbox_manager_lootbox_id': 'lootboxManagerLootboxId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'lootbox_manager_id': 'path',
                    'lootbox_manager_lootbox_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_lootbox_manager_lootbox_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers/{lootboxManagerId}/lootboxes/{lootboxManagerLootboxId}',
                'operation_id': 'remove_lootbox_manager_lootbox',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'lootbox_manager_id',
                    'lootbox_manager_lootbox_id',
                    'x_authorization',
                    'x_password',
                ],
                'required': [
                    'lootbox_manager_id',
                    'lootbox_manager_lootbox_id',
                    'x_authorization',
                    'x_password',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'lootbox_manager_id':
                        (str,),
                    'lootbox_manager_lootbox_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                },
                'attribute_map': {
                    'lootbox_manager_id': 'lootboxManagerId',
                    'lootbox_manager_lootbox_id': 'lootboxManagerLootboxId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'lootbox_manager_id': 'path',
                    'lootbox_manager_lootbox_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.set_lootbox_manager_lootbox_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionModel,),
                'auth': [],
                'endpoint_path': '/v1/lootboxManagers/{lootboxManagerId}/lootboxes',
                'operation_id': 'set_lootbox_manager_lootbox',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'lootbox_manager_id',
                    'x_authorization',
                    'x_password',
                    'set_lootbox_manager_lootbox_request',
                ],
                'required': [
                    'lootbox_manager_id',
                    'x_authorization',
                    'x_password',
                    'set_lootbox_manager_lootbox_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'lootbox_manager_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_password':
                        (str,),
                    'set_lootbox_manager_lootbox_request':
                        (SetLootboxManagerLootboxRequest,),
                },
                'attribute_map': {
                    'lootbox_manager_id': 'lootboxManagerId',
                    'x_authorization': 'X-Authorization',
                    'x_password': 'X-Password',
                },
                'location_map': {
                    'lootbox_manager_id': 'path',
                    'x_authorization': 'header',
                    'x_password': 'header',
                    'set_lootbox_manager_lootbox_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_lootbox_manager(
        self,
        x_authorization,
        x_password,
        create_lootbox_manager_request,
        **kwargs
    ):
        """Create lootbox manager  # noqa: E501

        Creates a new game lootbox manager and deploys a lootbox manager contract on behalf of the authenticating game's primary wallet. The deployed lootbox manager contract allows you to create lootbox behavior for existing items. For example, you can define item id(s) from one of your item collections as the requirement(s) to open a \"lootbox\". The required item(s) would be burned from the interacting player's wallet and the player would receive item(s) from a weighted randomized set of possible items the lootbox can contain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lootbox_manager(x_authorization, x_password, create_lootbox_manager_request, async_req=True)
        >>> result = thread.get()

        Args:
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            create_lootbox_manager_request (CreateLootboxManagerRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateLootboxManager200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['create_lootbox_manager_request'] = \
            create_lootbox_manager_request
        return self.create_lootbox_manager_endpoint.call_with_http_info(**kwargs)

    def get_lootbox_manager_lootbox(
        self,
        lootbox_manager_id,
        lootbox_manager_lootbox_id,
        **kwargs
    ):
        """Get lootbox manager lootbox  # noqa: E501

        Returns a lootbox manager lootbox object for the provided lootboxManagerLootboxId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lootbox_manager_lootbox(lootbox_manager_id, lootbox_manager_lootbox_id, async_req=True)
        >>> result = thread.get()

        Args:
            lootbox_manager_id (str): Any lootbox manager id within the MetaFab ecosystem.
            lootbox_manager_lootbox_id (str): Any lootbox manager lootbox id within the MetaFab ecosystem.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            LootboxManagerLootbox
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['lootbox_manager_id'] = \
            lootbox_manager_id
        kwargs['lootbox_manager_lootbox_id'] = \
            lootbox_manager_lootbox_id
        return self.get_lootbox_manager_lootbox_endpoint.call_with_http_info(**kwargs)

    def get_lootbox_manager_lootboxes(
        self,
        lootbox_manager_id,
        **kwargs
    ):
        """Get lootbox manager lootboxes  # noqa: E501

        Returns all lootbox manager lootboxes as an array of lootbox objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lootbox_manager_lootboxes(lootbox_manager_id, async_req=True)
        >>> result = thread.get()

        Args:
            lootbox_manager_id (str): Any lootbox manager id within the MetaFab ecosystem.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [LootboxManagerLootbox]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['lootbox_manager_id'] = \
            lootbox_manager_id
        return self.get_lootbox_manager_lootboxes_endpoint.call_with_http_info(**kwargs)

    def get_lootbox_managers(
        self,
        x_game_key,
        **kwargs
    ):
        """Get lootbox managers  # noqa: E501

        Returns an array of active lootbox managers for the game associated with the provided `X-Game-Key`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lootbox_managers(x_game_key, async_req=True)
        >>> result = thread.get()

        Args:
            x_game_key (str): The `publishedKey` of a specific game. This can be shared or included in game clients, websites, etc.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [GetLootboxManagers200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_game_key'] = \
            x_game_key
        return self.get_lootbox_managers_endpoint.call_with_http_info(**kwargs)

    def open_lootbox_manager_lootbox(
        self,
        lootbox_manager_id,
        lootbox_manager_lootbox_id,
        x_authorization,
        x_password,
        **kwargs
    ):
        """Open lootbox manager lootbox  # noqa: E501

        Opens a lootbox manager lootbox. The required input item(s) are burned from the wallet or player wallet opening the lootbox. The given output item(s) are given to the wallet or player wallet opening the lootbox.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.open_lootbox_manager_lootbox(lootbox_manager_id, lootbox_manager_lootbox_id, x_authorization, x_password, async_req=True)
        >>> result = thread.get()

        Args:
            lootbox_manager_id (str): Any lootbox manager id within the MetaFab ecosystem.
            lootbox_manager_lootbox_id (str): Any lootbox manager lootbox id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of a specific game or the `accessToken` of a specific player.
            x_password (str): The password of the authenticating game or player. Required to decrypt and perform blockchain transactions with the game or player primary wallet.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [TransactionModel]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['lootbox_manager_id'] = \
            lootbox_manager_id
        kwargs['lootbox_manager_lootbox_id'] = \
            lootbox_manager_lootbox_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        return self.open_lootbox_manager_lootbox_endpoint.call_with_http_info(**kwargs)

    def remove_lootbox_manager_lootbox(
        self,
        lootbox_manager_id,
        lootbox_manager_lootbox_id,
        x_authorization,
        x_password,
        **kwargs
    ):
        """Remove lootbox manager lootbox  # noqa: E501

        Removes the provided lootbox by lootboxId from the provided lootbox manager. Removed lootboxes can no longer be used.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_lootbox_manager_lootbox(lootbox_manager_id, lootbox_manager_lootbox_id, x_authorization, x_password, async_req=True)
        >>> result = thread.get()

        Args:
            lootbox_manager_id (str): Any lootbox manager id within the MetaFab ecosystem.
            lootbox_manager_lootbox_id (str): Any lootbox manager lootbox id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['lootbox_manager_id'] = \
            lootbox_manager_id
        kwargs['lootbox_manager_lootbox_id'] = \
            lootbox_manager_lootbox_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        return self.remove_lootbox_manager_lootbox_endpoint.call_with_http_info(**kwargs)

    def set_lootbox_manager_lootbox(
        self,
        lootbox_manager_id,
        x_authorization,
        x_password,
        set_lootbox_manager_lootbox_request,
        **kwargs
    ):
        """Set lootbox manager lootbox  # noqa: E501

        Sets a new lootbox manager lootbox or updates an existing one for the provided id. Lootboxes allow item(s) to be burned to receive a random set of possible item(s) based on probability weight.  Lootboxes can require any number of unique types of items and quantities to open a created lootbox type within the system. A common pattern with lootboxes is to create a lootbox item type within an item collection, and require it as the input item type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_lootbox_manager_lootbox(lootbox_manager_id, x_authorization, x_password, set_lootbox_manager_lootbox_request, async_req=True)
        >>> result = thread.get()

        Args:
            lootbox_manager_id (str): Any lootbox manager id within the MetaFab ecosystem.
            x_authorization (str): The `secretKey` of the authenticating game.
            x_password (str): The password of the authenticating game. Required to decrypt and perform blockchain transactions with the game primary wallet.
            set_lootbox_manager_lootbox_request (SetLootboxManagerLootboxRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TransactionModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['lootbox_manager_id'] = \
            lootbox_manager_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_password'] = \
            x_password
        kwargs['set_lootbox_manager_lootbox_request'] = \
            set_lootbox_manager_lootbox_request
        return self.set_lootbox_manager_lootbox_endpoint.call_with_http_info(**kwargs)

