"""
    MetaFab API

    Complete MetaFab API references and guides can be found at: https://trymetafab.com  # noqa: E501

    The version of the OpenAPI document: 1.5.1
    Contact: metafabproject@gmail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from metafab_python.api_client import ApiClient, Endpoint as _Endpoint
from metafab_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from metafab_python.model.approve_ecosystem_game_request import ApproveEcosystemGameRequest
from metafab_python.model.auth_player200_response import AuthPlayer200Response
from metafab_python.model.auth_profile200_response import AuthProfile200Response
from metafab_python.model.create_ecosystem_request import CreateEcosystemRequest
from metafab_python.model.create_profile_player_request import CreateProfilePlayerRequest
from metafab_python.model.create_profile_request import CreateProfileRequest
from metafab_python.model.ecosystem_model import EcosystemModel
from metafab_python.model.get_profile_games200_response_inner import GetProfileGames200ResponseInner
from metafab_python.model.profile_model import ProfileModel
from metafab_python.model.public_ecosystem import PublicEcosystem
from metafab_python.model.public_game import PublicGame
from metafab_python.model.update_ecosystem_request import UpdateEcosystemRequest
from metafab_python.model.update_profile_player200_response import UpdateProfilePlayer200Response
from metafab_python.model.update_profile_player_request import UpdateProfilePlayerRequest
from metafab_python.model.update_profile_request import UpdateProfileRequest


class EcosystemsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.approve_ecosystem_game_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/ecosystems/{ecosystemId}/games',
                'operation_id': 'approve_ecosystem_game',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'ecosystem_id',
                    'x_authorization',
                    'approve_ecosystem_game_request',
                ],
                'required': [
                    'ecosystem_id',
                    'x_authorization',
                    'approve_ecosystem_game_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ecosystem_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'approve_ecosystem_game_request':
                        (ApproveEcosystemGameRequest,),
                },
                'attribute_map': {
                    'ecosystem_id': 'ecosystemId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'ecosystem_id': 'path',
                    'x_authorization': 'header',
                    'approve_ecosystem_game_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.auth_ecosystem_endpoint = _Endpoint(
            settings={
                'response_type': (EcosystemModel,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/v1/ecosystems/auth',
                'operation_id': 'auth_ecosystem',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.auth_profile_endpoint = _Endpoint(
            settings={
                'response_type': (AuthProfile200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/v1/profiles/auth',
                'operation_id': 'auth_profile',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_ecosystem_key',
                ],
                'required': [
                    'x_ecosystem_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_ecosystem_key':
                        (str,),
                },
                'attribute_map': {
                    'x_ecosystem_key': 'X-Ecosystem-Key',
                },
                'location_map': {
                    'x_ecosystem_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.auth_profile_player_endpoint = _Endpoint(
            settings={
                'response_type': (AuthPlayer200Response,),
                'auth': [],
                'endpoint_path': '/v1/profiles/{profileId}/games/{gameId}/players/auth',
                'operation_id': 'auth_profile_player',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'game_id',
                    'x_authorization',
                    'x_wallet_decrypt_key',
                    'x_username',
                ],
                'required': [
                    'profile_id',
                    'game_id',
                    'x_authorization',
                    'x_wallet_decrypt_key',
                    'x_username',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'game_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_wallet_decrypt_key':
                        (str,),
                    'x_username':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'game_id': 'gameId',
                    'x_authorization': 'X-Authorization',
                    'x_wallet_decrypt_key': 'X-Wallet-Decrypt-Key',
                    'x_username': 'X-Username',
                },
                'location_map': {
                    'profile_id': 'path',
                    'game_id': 'path',
                    'x_authorization': 'header',
                    'x_wallet_decrypt_key': 'header',
                    'x_username': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_ecosystem_endpoint = _Endpoint(
            settings={
                'response_type': (EcosystemModel,),
                'auth': [],
                'endpoint_path': '/v1/ecosystems',
                'operation_id': 'create_ecosystem',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_ecosystem_request',
                ],
                'required': [
                    'create_ecosystem_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_ecosystem_request':
                        (CreateEcosystemRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'create_ecosystem_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_profile_endpoint = _Endpoint(
            settings={
                'response_type': (AuthProfile200Response,),
                'auth': [],
                'endpoint_path': '/v1/profiles',
                'operation_id': 'create_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_ecosystem_key',
                    'create_profile_request',
                ],
                'required': [
                    'x_ecosystem_key',
                    'create_profile_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_ecosystem_key':
                        (str,),
                    'create_profile_request':
                        (CreateProfileRequest,),
                },
                'attribute_map': {
                    'x_ecosystem_key': 'X-Ecosystem-Key',
                },
                'location_map': {
                    'x_ecosystem_key': 'header',
                    'create_profile_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_profile_player_endpoint = _Endpoint(
            settings={
                'response_type': (AuthPlayer200Response,),
                'auth': [],
                'endpoint_path': '/v1/profiles/{profileId}/games/{gameId}/players',
                'operation_id': 'create_profile_player',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'game_id',
                    'x_authorization',
                    'x_wallet_decrypt_key',
                    'create_profile_player_request',
                ],
                'required': [
                    'profile_id',
                    'game_id',
                    'x_authorization',
                    'x_wallet_decrypt_key',
                    'create_profile_player_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'game_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_wallet_decrypt_key':
                        (str,),
                    'create_profile_player_request':
                        (CreateProfilePlayerRequest,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'game_id': 'gameId',
                    'x_authorization': 'X-Authorization',
                    'x_wallet_decrypt_key': 'X-Wallet-Decrypt-Key',
                },
                'location_map': {
                    'profile_id': 'path',
                    'game_id': 'path',
                    'x_authorization': 'header',
                    'x_wallet_decrypt_key': 'header',
                    'create_profile_player_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_ecosystem_endpoint = _Endpoint(
            settings={
                'response_type': (PublicEcosystem,),
                'auth': [],
                'endpoint_path': '/v1/ecosystems/{ecosystemId}',
                'operation_id': 'get_ecosystem',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ecosystem_id',
                ],
                'required': [
                    'ecosystem_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ecosystem_id':
                        (str,),
                },
                'attribute_map': {
                    'ecosystem_id': 'ecosystemId',
                },
                'location_map': {
                    'ecosystem_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ecosystem_game_endpoint = _Endpoint(
            settings={
                'response_type': (PublicGame,),
                'auth': [],
                'endpoint_path': '/v1/ecosystems/{ecosystemId}/games/{gameId}',
                'operation_id': 'get_ecosystem_game',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ecosystem_id',
                    'game_id',
                ],
                'required': [
                    'ecosystem_id',
                    'game_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ecosystem_id':
                        (str,),
                    'game_id':
                        (str,),
                },
                'attribute_map': {
                    'ecosystem_id': 'ecosystemId',
                    'game_id': 'gameId',
                },
                'location_map': {
                    'ecosystem_id': 'path',
                    'game_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_ecosystem_games_endpoint = _Endpoint(
            settings={
                'response_type': ([PublicGame],),
                'auth': [],
                'endpoint_path': '/v1/ecosystems/{ecosystemId}/games',
                'operation_id': 'get_ecosystem_games',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ecosystem_id',
                ],
                'required': [
                    'ecosystem_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ecosystem_id':
                        (str,),
                },
                'attribute_map': {
                    'ecosystem_id': 'ecosystemId',
                },
                'location_map': {
                    'ecosystem_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_profile_game_endpoint = _Endpoint(
            settings={
                'response_type': (GetProfileGames200ResponseInner,),
                'auth': [],
                'endpoint_path': '/v1/profiles/{profileId}/games/{gameId}',
                'operation_id': 'get_profile_game',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'game_id',
                    'x_authorization',
                ],
                'required': [
                    'profile_id',
                    'game_id',
                    'x_authorization',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'game_id':
                        (str,),
                    'x_authorization':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'game_id': 'gameId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'profile_id': 'path',
                    'game_id': 'path',
                    'x_authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_profile_games_endpoint = _Endpoint(
            settings={
                'response_type': ([GetProfileGames200ResponseInner],),
                'auth': [],
                'endpoint_path': '/v1/profiles/{profileId}/games',
                'operation_id': 'get_profile_games',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'x_authorization',
                ],
                'required': [
                    'profile_id',
                    'x_authorization',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'x_authorization':
                        (str,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'profile_id': 'path',
                    'x_authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.unapprove_ecosystem_game_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/ecosystems/{ecosystemId}/games/{gameId}',
                'operation_id': 'unapprove_ecosystem_game',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'ecosystem_id',
                    'game_id',
                    'x_authorization',
                ],
                'required': [
                    'ecosystem_id',
                    'game_id',
                    'x_authorization',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ecosystem_id':
                        (str,),
                    'game_id':
                        (str,),
                    'x_authorization':
                        (str,),
                },
                'attribute_map': {
                    'ecosystem_id': 'ecosystemId',
                    'game_id': 'gameId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'ecosystem_id': 'path',
                    'game_id': 'path',
                    'x_authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_ecosystem_endpoint = _Endpoint(
            settings={
                'response_type': (EcosystemModel,),
                'auth': [],
                'endpoint_path': '/v1/ecosystems/{ecosystemId}',
                'operation_id': 'update_ecosystem',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'ecosystem_id',
                    'x_authorization',
                    'update_ecosystem_request',
                ],
                'required': [
                    'ecosystem_id',
                    'x_authorization',
                    'update_ecosystem_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ecosystem_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'update_ecosystem_request':
                        (UpdateEcosystemRequest,),
                },
                'attribute_map': {
                    'ecosystem_id': 'ecosystemId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'ecosystem_id': 'path',
                    'x_authorization': 'header',
                    'update_ecosystem_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_profile_endpoint = _Endpoint(
            settings={
                'response_type': (ProfileModel,),
                'auth': [],
                'endpoint_path': '/v1/profiles/{profileId}',
                'operation_id': 'update_profile',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'x_authorization',
                    'update_profile_request',
                ],
                'required': [
                    'profile_id',
                    'x_authorization',
                    'update_profile_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'update_profile_request':
                        (UpdateProfileRequest,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'profile_id': 'path',
                    'x_authorization': 'header',
                    'update_profile_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_profile_player_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateProfilePlayer200Response,),
                'auth': [],
                'endpoint_path': '/v1/profiles/{profileId}/games/{gameId}/players/{playerId}',
                'operation_id': 'update_profile_player',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'profile_id',
                    'game_id',
                    'player_id',
                    'x_authorization',
                    'x_wallet_decrypt_key',
                    'update_profile_player_request',
                ],
                'required': [
                    'profile_id',
                    'game_id',
                    'player_id',
                    'x_authorization',
                    'x_wallet_decrypt_key',
                    'update_profile_player_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'profile_id':
                        (str,),
                    'game_id':
                        (str,),
                    'player_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'x_wallet_decrypt_key':
                        (str,),
                    'update_profile_player_request':
                        (UpdateProfilePlayerRequest,),
                },
                'attribute_map': {
                    'profile_id': 'profileId',
                    'game_id': 'gameId',
                    'player_id': 'playerId',
                    'x_authorization': 'X-Authorization',
                    'x_wallet_decrypt_key': 'X-Wallet-Decrypt-Key',
                },
                'location_map': {
                    'profile_id': 'path',
                    'game_id': 'path',
                    'player_id': 'path',
                    'x_authorization': 'header',
                    'x_wallet_decrypt_key': 'header',
                    'update_profile_player_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def approve_ecosystem_game(
        self,
        ecosystem_id,
        x_authorization,
        approve_ecosystem_game_request,
        **kwargs
    ):
        """Approve ecosystem game  # noqa: E501

        Approves a game for an ecosystem. By approving a game, it allows that game to integrate the ability for profile accounts from an ecosystem to login directly to the approved game and play. This also allows games to request access to assets held at the profile level for the game to frictionlessly interact with on behalf of the profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.approve_ecosystem_game(ecosystem_id, x_authorization, approve_ecosystem_game_request, async_req=True)
        >>> result = thread.get()

        Args:
            ecosystem_id (str): The ecosystem id of the authenticating ecosystem.
            x_authorization (str): The `secretKey` of the authenticating ecosystem.
            approve_ecosystem_game_request (ApproveEcosystemGameRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ecosystem_id'] = \
            ecosystem_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['approve_ecosystem_game_request'] = \
            approve_ecosystem_game_request
        return self.approve_ecosystem_game_endpoint.call_with_http_info(**kwargs)

    def auth_ecosystem(
        self,
        **kwargs
    ):
        """Authenticate ecosystem  # noqa: E501

        Returns an existing ecosystem object containing authorization keys when provided a valid email (in place of username) and password login using Basic Auth.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.auth_ecosystem(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EcosystemModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.auth_ecosystem_endpoint.call_with_http_info(**kwargs)

    def auth_profile(
        self,
        x_ecosystem_key,
        **kwargs
    ):
        """Authenticate profile  # noqa: E501

        Returns an existing profile object containing access token, wallet, and other details when provided a valid profile username and password login using Basic Auth.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.auth_profile(x_ecosystem_key, async_req=True)
        >>> result = thread.get()

        Args:
            x_ecosystem_key (str): The `publishedKey` of a specific ecosystem. This can be shared or included in clients, websites, etc.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthProfile200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_ecosystem_key'] = \
            x_ecosystem_key
        return self.auth_profile_endpoint.call_with_http_info(**kwargs)

    def auth_profile_player(
        self,
        profile_id,
        game_id,
        x_authorization,
        x_wallet_decrypt_key,
        x_username,
        **kwargs
    ):
        """Authenticate profile player  # noqa: E501

        Returns an existing player object containing access token, wallet, wallet decrypt key, profile authorization and other details for a game when provided profile authentication and the player's username.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.auth_profile_player(profile_id, game_id, x_authorization, x_wallet_decrypt_key, x_username, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): The profile id of the authenticating profile.
            game_id (str): Any game id within the MetaFab platform.
            x_authorization (str): The `accessToken` of the authenticating profile.
            x_wallet_decrypt_key (str): The `walletDecryptKey` of the authenticating profile. Required to decrypt and perform blockchain transactions with the profile wallet.
            x_username (str): The username of a player.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthPlayer200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['game_id'] = \
            game_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_wallet_decrypt_key'] = \
            x_wallet_decrypt_key
        kwargs['x_username'] = \
            x_username
        return self.auth_profile_player_endpoint.call_with_http_info(**kwargs)

    def create_ecosystem(
        self,
        create_ecosystem_request,
        **kwargs
    ):
        """Create ecosystem  # noqa: E501

        Create a new ecosystem. An ecosystem is a parent entity that many profiles live under for a given ecosystem of games. Ecosystems allow your players to create one profile within your ecosystem that allows a single account and wallet to be used across all of the approved games in your ecosystem that they play.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_ecosystem(create_ecosystem_request, async_req=True)
        >>> result = thread.get()

        Args:
            create_ecosystem_request (CreateEcosystemRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EcosystemModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['create_ecosystem_request'] = \
            create_ecosystem_request
        return self.create_ecosystem_endpoint.call_with_http_info(**kwargs)

    def create_profile(
        self,
        x_ecosystem_key,
        create_profile_request,
        **kwargs
    ):
        """Create profile  # noqa: E501

        Create a new profile. Profiles are automatically associated with an internally managed wallet. Profiles can be thought of as a umbrella account that can be used to sign into and create player accounts across many games and have a singular asset store wallet at the profile level that can be used across all connected player accounts for games those player accounts are a part of.  Profiles are associated to a parent ecosystem of games. This allows an ecosystem to approve a permissioned set of games that can request authorized wallet permissions from profiles of players for their game.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_profile(x_ecosystem_key, create_profile_request, async_req=True)
        >>> result = thread.get()

        Args:
            x_ecosystem_key (str): The `publishedKey` of a specific ecosystem. This can be shared or included in clients, websites, etc.
            create_profile_request (CreateProfileRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthProfile200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_ecosystem_key'] = \
            x_ecosystem_key
        kwargs['create_profile_request'] = \
            create_profile_request
        return self.create_profile_endpoint.call_with_http_info(**kwargs)

    def create_profile_player(
        self,
        profile_id,
        game_id,
        x_authorization,
        x_wallet_decrypt_key,
        create_profile_player_request,
        **kwargs
    ):
        """Create profile player  # noqa: E501

        Creates a new player account for the provided game id linked to the authenticating profile. The created player account will default to using the parent profile's wallet for any transactions, wallet content balance checks and verifications, and more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_profile_player(profile_id, game_id, x_authorization, x_wallet_decrypt_key, create_profile_player_request, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): The profile id of the authenticating profile.
            game_id (str): Any game id within the MetaFab platform.
            x_authorization (str): The `accessToken` of the authenticating profile.
            x_wallet_decrypt_key (str): The `walletDecryptKey` of the authenticating profile. Required to decrypt and perform blockchain transactions with the profile wallet.
            create_profile_player_request (CreateProfilePlayerRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthPlayer200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['game_id'] = \
            game_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_wallet_decrypt_key'] = \
            x_wallet_decrypt_key
        kwargs['create_profile_player_request'] = \
            create_profile_player_request
        return self.create_profile_player_endpoint.call_with_http_info(**kwargs)

    def get_ecosystem(
        self,
        ecosystem_id,
        **kwargs
    ):
        """Get ecosystem  # noqa: E501

        Returns a ecosystem object for the provided ecosystem id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ecosystem(ecosystem_id, async_req=True)
        >>> result = thread.get()

        Args:
            ecosystem_id (str): Any ecosystem id within the MetaFab platform.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PublicEcosystem
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ecosystem_id'] = \
            ecosystem_id
        return self.get_ecosystem_endpoint.call_with_http_info(**kwargs)

    def get_ecosystem_game(
        self,
        ecosystem_id,
        game_id,
        **kwargs
    ):
        """Get ecosystem game  # noqa: E501

        Returns a game object for the provided game id that the ecosystem has approved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ecosystem_game(ecosystem_id, game_id, async_req=True)
        >>> result = thread.get()

        Args:
            ecosystem_id (str): Any ecosystem id within the MetaFab platform.
            game_id (str): Any game id within the MetaFab platform.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PublicGame
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ecosystem_id'] = \
            ecosystem_id
        kwargs['game_id'] = \
            game_id
        return self.get_ecosystem_game_endpoint.call_with_http_info(**kwargs)

    def get_ecosystem_games(
        self,
        ecosystem_id,
        **kwargs
    ):
        """Get ecosystem games  # noqa: E501

        Returns an array of games the ecosystem has approved.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_ecosystem_games(ecosystem_id, async_req=True)
        >>> result = thread.get()

        Args:
            ecosystem_id (str): Any ecosystem id within the MetaFab platform.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [PublicGame]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ecosystem_id'] = \
            ecosystem_id
        return self.get_ecosystem_games_endpoint.call_with_http_info(**kwargs)

    def get_profile_game(
        self,
        profile_id,
        game_id,
        x_authorization,
        **kwargs
    ):
        """Get profile game  # noqa: E501

        Returns a game this profile has connected player accounts for.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_profile_game(profile_id, game_id, x_authorization, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): The profile id of the authenticating profile.
            game_id (str): Any game id within the MetaFab platform.
            x_authorization (str): The `accessToken` of the authenticating profile.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetProfileGames200ResponseInner
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['game_id'] = \
            game_id
        kwargs['x_authorization'] = \
            x_authorization
        return self.get_profile_game_endpoint.call_with_http_info(**kwargs)

    def get_profile_games(
        self,
        profile_id,
        x_authorization,
        **kwargs
    ):
        """Get profile games  # noqa: E501

        Returns an array of games the authorized profile has connected player accounts for.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_profile_games(profile_id, x_authorization, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): The profile id of the authenticating profile.
            x_authorization (str): The `accessToken` of the authenticating profile.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [GetProfileGames200ResponseInner]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['x_authorization'] = \
            x_authorization
        return self.get_profile_games_endpoint.call_with_http_info(**kwargs)

    def unapprove_ecosystem_game(
        self,
        ecosystem_id,
        game_id,
        x_authorization,
        **kwargs
    ):
        """Unapprove ecosystem game  # noqa: E501

        Unapproves a game for an ecosystem. The game will no longer be able to allow profiles from the ecosystem to login. All profile permissions approved for the game will also be revoked.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.unapprove_ecosystem_game(ecosystem_id, game_id, x_authorization, async_req=True)
        >>> result = thread.get()

        Args:
            ecosystem_id (str): The ecosystem id of the authenticating ecosystem.
            game_id (str): Any game id within the MetaFab platform.
            x_authorization (str): The `secretKey` of the authenticating ecosystem.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ecosystem_id'] = \
            ecosystem_id
        kwargs['game_id'] = \
            game_id
        kwargs['x_authorization'] = \
            x_authorization
        return self.unapprove_ecosystem_game_endpoint.call_with_http_info(**kwargs)

    def update_ecosystem(
        self,
        ecosystem_id,
        x_authorization,
        update_ecosystem_request,
        **kwargs
    ):
        """Update ecosystem  # noqa: E501

        Update various fields specific to an ecosystem. Such as changing its password, resetting its published or secret key, or updating its approved games.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ecosystem(ecosystem_id, x_authorization, update_ecosystem_request, async_req=True)
        >>> result = thread.get()

        Args:
            ecosystem_id (str): The ecosystem id of the authenticating ecosystem.
            x_authorization (str): The `secretKey` of the authenticating ecosystem.
            update_ecosystem_request (UpdateEcosystemRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EcosystemModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['ecosystem_id'] = \
            ecosystem_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['update_ecosystem_request'] = \
            update_ecosystem_request
        return self.update_ecosystem_endpoint.call_with_http_info(**kwargs)

    def update_profile(
        self,
        profile_id,
        x_authorization,
        update_profile_request,
        **kwargs
    ):
        """Update profile  # noqa: E501

        Update various fields specific to a profile. Such as changing its password and resetting its access token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_profile(profile_id, x_authorization, update_profile_request, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): The profile id of the authenticating profile.
            x_authorization (str): The `accessToken` of the authenticating profile.
            update_profile_request (UpdateProfileRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ProfileModel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['update_profile_request'] = \
            update_profile_request
        return self.update_profile_endpoint.call_with_http_info(**kwargs)

    def update_profile_player(
        self,
        profile_id,
        game_id,
        player_id,
        x_authorization,
        x_wallet_decrypt_key,
        update_profile_player_request,
        **kwargs
    ):
        """Update profile player  # noqa: E501

        Update various fields specific to a player. Such as changing its permissions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_profile_player(profile_id, game_id, player_id, x_authorization, x_wallet_decrypt_key, update_profile_player_request, async_req=True)
        >>> result = thread.get()

        Args:
            profile_id (str): The profile id of the authenticating profile.
            game_id (str): Any game id within the MetaFab platform.
            player_id (str): Any player id within the MetaFab platform.
            x_authorization (str): The `accessToken` of the authenticating profile.
            x_wallet_decrypt_key (str): The `walletDecryptKey` of the authenticating profile. Required to decrypt and perform blockchain transactions with the profile wallet.
            update_profile_player_request (UpdateProfilePlayerRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateProfilePlayer200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['profile_id'] = \
            profile_id
        kwargs['game_id'] = \
            game_id
        kwargs['player_id'] = \
            player_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['x_wallet_decrypt_key'] = \
            x_wallet_decrypt_key
        kwargs['update_profile_player_request'] = \
            update_profile_player_request
        return self.update_profile_player_endpoint.call_with_http_info(**kwargs)

