"""
    MetaFab API

    Complete MetaFab API references and guides can be found at: https://trymetafab.com  # noqa: E501

    The version of the OpenAPI document: 1.5.1
    Contact: metafabproject@gmail.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from metafab_python.api_client import ApiClient, Endpoint as _Endpoint
from metafab_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from metafab_python.model.auth_player200_response import AuthPlayer200Response
from metafab_python.model.create_player_request import CreatePlayerRequest
from metafab_python.model.get_player_data200_response import GetPlayerData200Response
from metafab_python.model.public_player import PublicPlayer
from metafab_python.model.remove_player_connected_wallet_request import RemovePlayerConnectedWalletRequest
from metafab_python.model.set_player_connected_wallet200_response import SetPlayerConnectedWallet200Response
from metafab_python.model.set_player_connected_wallet_request import SetPlayerConnectedWalletRequest
from metafab_python.model.set_player_data_request import SetPlayerDataRequest
from metafab_python.model.update_player200_response import UpdatePlayer200Response
from metafab_python.model.update_player_request import UpdatePlayerRequest


class PlayersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.auth_player_endpoint = _Endpoint(
            settings={
                'response_type': (AuthPlayer200Response,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/v1/players/auth',
                'operation_id': 'auth_player',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_game_key',
                ],
                'required': [
                    'x_game_key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_game_key':
                        (str,),
                },
                'attribute_map': {
                    'x_game_key': 'X-Game-Key',
                },
                'location_map': {
                    'x_game_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_player_endpoint = _Endpoint(
            settings={
                'response_type': (AuthPlayer200Response,),
                'auth': [],
                'endpoint_path': '/v1/players',
                'operation_id': 'create_player',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_game_key',
                    'create_player_request',
                ],
                'required': [
                    'x_game_key',
                    'create_player_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_game_key':
                        (str,),
                    'create_player_request':
                        (CreatePlayerRequest,),
                },
                'attribute_map': {
                    'x_game_key': 'X-Game-Key',
                },
                'location_map': {
                    'x_game_key': 'header',
                    'create_player_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_player_endpoint = _Endpoint(
            settings={
                'response_type': (PublicPlayer,),
                'auth': [],
                'endpoint_path': '/v1/players/{playerId}',
                'operation_id': 'get_player',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'player_id',
                ],
                'required': [
                    'player_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'player_id':
                        (str,),
                },
                'attribute_map': {
                    'player_id': 'playerId',
                },
                'location_map': {
                    'player_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_player_data_endpoint = _Endpoint(
            settings={
                'response_type': (GetPlayerData200Response,),
                'auth': [],
                'endpoint_path': '/v1/players/{playerId}/data',
                'operation_id': 'get_player_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'player_id',
                ],
                'required': [
                    'player_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'player_id':
                        (str,),
                },
                'attribute_map': {
                    'player_id': 'playerId',
                },
                'location_map': {
                    'player_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_players_endpoint = _Endpoint(
            settings={
                'response_type': ([PublicPlayer],),
                'auth': [],
                'endpoint_path': '/v1/players',
                'operation_id': 'get_players',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_authorization',
                ],
                'required': [
                    'x_authorization',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_authorization':
                        (str,),
                },
                'attribute_map': {
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'x_authorization': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_player_connected_wallet_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v1/players/{playerId}/wallets/{playerWalletId}',
                'operation_id': 'remove_player_connected_wallet',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'player_id',
                    'player_wallet_id',
                    'remove_player_connected_wallet_request',
                ],
                'required': [
                    'player_id',
                    'player_wallet_id',
                    'remove_player_connected_wallet_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'player_id':
                        (str,),
                    'player_wallet_id':
                        (str,),
                    'remove_player_connected_wallet_request':
                        (RemovePlayerConnectedWalletRequest,),
                },
                'attribute_map': {
                    'player_id': 'playerId',
                    'player_wallet_id': 'playerWalletId',
                },
                'location_map': {
                    'player_id': 'path',
                    'player_wallet_id': 'path',
                    'remove_player_connected_wallet_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.set_player_connected_wallet_endpoint = _Endpoint(
            settings={
                'response_type': (SetPlayerConnectedWallet200Response,),
                'auth': [],
                'endpoint_path': '/v1/players/{playerId}/wallets',
                'operation_id': 'set_player_connected_wallet',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'player_id',
                    'x_authorization',
                    'set_player_connected_wallet_request',
                ],
                'required': [
                    'player_id',
                    'x_authorization',
                    'set_player_connected_wallet_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'player_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'set_player_connected_wallet_request':
                        (SetPlayerConnectedWalletRequest,),
                },
                'attribute_map': {
                    'player_id': 'playerId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'player_id': 'path',
                    'x_authorization': 'header',
                    'set_player_connected_wallet_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.set_player_data_endpoint = _Endpoint(
            settings={
                'response_type': (GetPlayerData200Response,),
                'auth': [],
                'endpoint_path': '/v1/players/{playerId}/data',
                'operation_id': 'set_player_data',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'player_id',
                    'x_authorization',
                    'set_player_data_request',
                ],
                'required': [
                    'player_id',
                    'x_authorization',
                    'set_player_data_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'player_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'set_player_data_request':
                        (SetPlayerDataRequest,),
                },
                'attribute_map': {
                    'player_id': 'playerId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'player_id': 'path',
                    'x_authorization': 'header',
                    'set_player_data_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_player_endpoint = _Endpoint(
            settings={
                'response_type': (UpdatePlayer200Response,),
                'auth': [],
                'endpoint_path': '/v1/players/{playerId}',
                'operation_id': 'update_player',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'player_id',
                    'x_authorization',
                    'update_player_request',
                ],
                'required': [
                    'player_id',
                    'x_authorization',
                    'update_player_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'player_id':
                        (str,),
                    'x_authorization':
                        (str,),
                    'update_player_request':
                        (UpdatePlayerRequest,),
                },
                'attribute_map': {
                    'player_id': 'playerId',
                    'x_authorization': 'X-Authorization',
                },
                'location_map': {
                    'player_id': 'path',
                    'x_authorization': 'header',
                    'update_player_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def auth_player(
        self,
        x_game_key,
        **kwargs
    ):
        """Authenticate player  # noqa: E501

        Returns an existing player object containing access token, wallet, and other details for a game when provided a valid username and password login using Basic Auth.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.auth_player(x_game_key, async_req=True)
        >>> result = thread.get()

        Args:
            x_game_key (str): The `publishedKey` of a specific game. This can be shared or included in game clients, websites, etc.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthPlayer200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_game_key'] = \
            x_game_key
        return self.auth_player_endpoint.call_with_http_info(**kwargs)

    def create_player(
        self,
        x_game_key,
        create_player_request,
        **kwargs
    ):
        """Create player  # noqa: E501

        Create a new player for a game. Players are automatically associated with an internally managed wallet.  Player access tokens can be used to directly interact with any MetaFab managed contracts, currencies, items collections, marketplaces and more. Player interactions are also gasless by default, completely removing all crypto friction for players to engage with your MetaFab supported games.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_player(x_game_key, create_player_request, async_req=True)
        >>> result = thread.get()

        Args:
            x_game_key (str): The `publishedKey` of a specific game. This can be shared or included in game clients, websites, etc.
            create_player_request (CreatePlayerRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthPlayer200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_game_key'] = \
            x_game_key
        kwargs['create_player_request'] = \
            create_player_request
        return self.create_player_endpoint.call_with_http_info(**kwargs)

    def get_player(
        self,
        player_id,
        **kwargs
    ):
        """Get player  # noqa: E501

        Returns a player object for the provided player id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_player(player_id, async_req=True)
        >>> result = thread.get()

        Args:
            player_id (str): Any player id within the MetaFab platform.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PublicPlayer
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['player_id'] = \
            player_id
        return self.get_player_endpoint.call_with_http_info(**kwargs)

    def get_player_data(
        self,
        player_id,
        **kwargs
    ):
        """Get player data  # noqa: E501

        Returns the latest public and protected data as an object for the provided playerId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_player_data(player_id, async_req=True)
        >>> result = thread.get()

        Args:
            player_id (str): Any player id within the MetaFab platform.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetPlayerData200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['player_id'] = \
            player_id
        return self.get_player_data_endpoint.call_with_http_info(**kwargs)

    def get_players(
        self,
        x_authorization,
        **kwargs
    ):
        """Get players  # noqa: E501

        Returns all players for the authenticated game as an array of player objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_players(x_authorization, async_req=True)
        >>> result = thread.get()

        Args:
            x_authorization (str): The `secretKey` of the authenticating game.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [PublicPlayer]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['x_authorization'] = \
            x_authorization
        return self.get_players_endpoint.call_with_http_info(**kwargs)

    def remove_player_connected_wallet(
        self,
        player_id,
        player_wallet_id,
        remove_player_connected_wallet_request,
        **kwargs
    ):
        """Remove player connected wallet  # noqa: E501

        Removes an external wallet from a player account. The player's wallet is reverted to their custodial wallet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_player_connected_wallet(player_id, player_wallet_id, remove_player_connected_wallet_request, async_req=True)
        >>> result = thread.get()

        Args:
            player_id (str): Any player id within the MetaFab platform.
            player_wallet_id (str): Any player wallet id within the MetaFab platform.
            remove_player_connected_wallet_request (RemovePlayerConnectedWalletRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['player_id'] = \
            player_id
        kwargs['player_wallet_id'] = \
            player_wallet_id
        kwargs['remove_player_connected_wallet_request'] = \
            remove_player_connected_wallet_request
        return self.remove_player_connected_wallet_endpoint.call_with_http_info(**kwargs)

    def set_player_connected_wallet(
        self,
        player_id,
        x_authorization,
        set_player_connected_wallet_request,
        **kwargs
    ):
        """Set player connected wallet  # noqa: E501

        Sets an external wallet as the wallet for a player account. The set wallet can transact gaslessly with all MetaFab related systems through the same MetaFab API calls as custodial wallets without requiring transaction signing or private keys.  This is done through an internal system MetaFab has created that allows an external connected wallet to delegate transaction signing for a specific game's set of contracts to a player's password protected custodial wallet. This allow the custodial wallet to sign and submit transactions to a specific game's related contracts as if they were signed and submitted by the connected external wallet. This also means that all earned tokens, purchased items and any interactions happen and are recorded on chain as the external connected wallet. No additional logic needs to be writted by developers to support both custodial and external wallets, everything just works.  Finally, this endpoint is meant for advanced users. The majority of developers who want to implement external wallet support for their game can do so without any extra work through our whitelabeled wallet connection feature that implements this endpoint underneath the hood without any required work.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_player_connected_wallet(player_id, x_authorization, set_player_connected_wallet_request, async_req=True)
        >>> result = thread.get()

        Args:
            player_id (str): The player id of the authenticating player.
            x_authorization (str): The `accessToken` of the authenticating player.
            set_player_connected_wallet_request (SetPlayerConnectedWalletRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SetPlayerConnectedWallet200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['player_id'] = \
            player_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['set_player_connected_wallet_request'] = \
            set_player_connected_wallet_request
        return self.set_player_connected_wallet_endpoint.call_with_http_info(**kwargs)

    def set_player_data(
        self,
        player_id,
        x_authorization,
        set_player_data_request,
        **kwargs
    ):
        """Set player data  # noqa: E501

        Creates or updates public and/or protected data for the provided playerId. Data updates are performed using deep merging. This means that when you update any top level or nested properties specific to player public or protected data, you only need to include the properties you are making changes to. Any existing properties not included in request body arguments will be retained on the player data object.  Please note, When writing an array type for a player, arrays do not follow the deep merge approach. If you add or remove an item from an array, the entire array must be passed as an argument when updating the related property for player public or protected data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.set_player_data(player_id, x_authorization, set_player_data_request, async_req=True)
        >>> result = thread.get()

        Args:
            player_id (str): Any player id within the MetaFab platform.
            x_authorization (str): The `secretKey` of a specific game or the `accessToken` of a specific player.
            set_player_data_request (SetPlayerDataRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GetPlayerData200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['player_id'] = \
            player_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['set_player_data_request'] = \
            set_player_data_request
        return self.set_player_data_endpoint.call_with_http_info(**kwargs)

    def update_player(
        self,
        player_id,
        x_authorization,
        update_player_request,
        **kwargs
    ):
        """Update player  # noqa: E501

        Update various fields specific to a player. Such as changing its password and resetting its access token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_player(player_id, x_authorization, update_player_request, async_req=True)
        >>> result = thread.get()

        Args:
            player_id (str): The player id of the authenticating player.
            x_authorization (str): The `accessToken` of the authenticating player.
            update_player_request (UpdatePlayerRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdatePlayer200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['player_id'] = \
            player_id
        kwargs['x_authorization'] = \
            x_authorization
        kwargs['update_player_request'] = \
            update_player_request
        return self.update_player_endpoint.call_with_http_info(**kwargs)

