import os
import tempfile

LONG_PASTE_THRESHOLD = int(os.environ.get("NANOCODE_LONG_PASTE_THRESHOLD", "4000"))


def save_long_paste(text: str) -> str:
    assert isinstance(text, str), "text must be a str"
    fd, path = tempfile.mkstemp(prefix="nanocode_paste_", suffix=".txt")
    with os.fdopen(fd, "w") as handle:
        handle.write(text)
    return path
