# GraphAPI

The GraphAPI class is a Python wrapper for interacting with the Microsoft Graph API, providing simplified access to Microsoft services such as Office 365, OneDrive, and Outlook. It abstracts away the complexity of authentication and API calls, allowing developers to easily perform actions like retrieving user information, accessing email messages, uploading and downloading files, creating folders, and more.

## Features

- Authenticate with Microsoft Azure Active Directory.
- Retrieve user information and email messages.
- Upload and download files to/from OneDrive.
- Create and manage folders in OneDrive.
- Search for files.
- Delete files and folders.
- Generate share links for files.
- Access advanced functionality of the Microsoft Graph API.

## Installation

1. Clone or download the repository.
2. Install the required dependencies using `pip install -r requirements.txt`.
3. Import the `GraphAPI` class into your Python project.

## Getting Started

1. Create an instance of the `GraphAPI` class with your Azure AD app credentials and user ID.
2. Use the provided methods to interact with the Microsoft Graph API and perform desired actions.
3. Refer to the code documentation and examples for detailed usage instructions.

```python
from graphapi import GraphAPI

# Create an instance of the GraphAPI class
api = GraphAPI(appid, client_secret, tenant_id, userid)

# Retrieve user information
api.get_information()

# Access email messages
mail = api.get_mail()

# Upload a file to OneDrive
api.upload_to_onedrive('file.txt', '/path/to/folder', access_token)

# Download a file from OneDrive
api.download_file('file.txt', '/path/to/folder', 'destination.txt')

# Create a folder in OneDrive
api.create_folder('new_folder')

# Search for files
search_results = api.search_for_file('keyword')

# Delete a file or folder
api.delete_file('file.txt', '/path/to/folder')

# Generate a share link for a file
share_link = api.create_share_link('file.txt', '/path/to/folder')

# Download Filename from OneDrive
download_by_filename('foo.txt')

```

## Contributing

Contributions are welcome! 

## License

This project is licensed under the [MIT License](LICENSE).
