class Font(object):
    """A styles pixel map of alphanumerical characters. This is an abstract
    font class mainly used as an example.
    """

    char_height = None
    char_width = None

    def get_char_map(self, character):
        raise NotImplementedError("This is a placeholder font.")


class FourByFiveFont(Font):

    char_height = 5
    char_width = 4

    char_map = {
        ' ': [0x0, 0x0, 0x0, 0x0, 0x0],
        '!': [0x4, 0x4, 0x4, 0x0, 0x4],
        '"': [0xa, 0xa, 0x0, 0x0, 0x0],
        '#': [0x6, 0xf, 0x6, 0xf, 0x6],
        '$': [0x7, 0xa, 0x6, 0x5, 0xe],
        '%': [0x7, 0xe, 0x4, 0x7, 0xe],
        '&': [0x2, 0x5, 0x6, 0xa, 0x5],
        '\'': [0x1, 0x2, 0x0, 0x0, 0x0],
        '(': [0x4, 0x8, 0x8, 0x8, 0x4],
        ')': [0x4, 0x2, 0x2, 0x2, 0x4],
        '*': [0x0, 0x6, 0xf, 0x6, 0x0],
        '+': [0x0, 0x2, 0x7, 0x2, 0x0],
        ',': [0x0, 0x0, 0x0, 0x2, 0x4],
        '-': [0x0, 0x0, 0x0, 0xf, 0x0],
        '.': [0x0, 0x0, 0x0, 0x0, 0x4],
        '/': [0x1, 0x1, 0x2, 0x4, 0x8],
        '0': [0x6, 0xb, 0xf, 0xd, 0x6],
        '1': [0x2, 0x6, 0x2, 0x2, 0x2],
        '2': [0xe, 0x1, 0x6, 0x8, 0xf],
        '3': [0xe, 0x1, 0x6, 0x1, 0xe],
        '4': [0x2, 0x6, 0xa, 0xf, 0x2],
        '5': [0xf, 0x8, 0xe, 0x1, 0xe],
        '6': [0x6, 0x8, 0xe, 0x9, 0x6],
        '7': [0xf, 0x1, 0x2, 0x4, 0x8],
        '8': [0x6, 0x9, 0x6, 0x9, 0x6],
        '9': [0x6, 0x9, 0xf, 0x1, 0x6],
        ':': [0x0, 0x4, 0x0, 0x4, 0x0],
        ';': [0x0, 0x4, 0x0, 0x4, 0x8],
        '<': [0x2, 0x4, 0x8, 0x4, 0x2],
        '=': [0x0, 0xf, 0x0, 0xf, 0x0],
        '>': [0x4, 0x2, 0x1, 0x2, 0x4],
        '?': [0x6, 0x9, 0x2, 0x0, 0x2],
        '@': [0x6, 0xd, 0xb, 0x8, 0x6],
        'A': [0x4, 0xa, 0xe, 0xa, 0xa],
        'B': [0xe, 0x9, 0xe, 0x9, 0xe],
        'C': [0x6, 0x9, 0x8, 0x9, 0x6],
        'D': [0xe, 0x9, 0x9, 0x9, 0xe],
        'E': [0xf, 0x8, 0xe, 0x8, 0xf],
        'F': [0xf, 0x8, 0xe, 0x8, 0x8],
        'G': [0x6, 0x8, 0xb, 0x9, 0x6],
        'H': [0x9, 0x9, 0xf, 0x9, 0x9],
        'I': [0xe, 0x4, 0x4, 0x4, 0xe],
        'J': [0x1, 0x1, 0x1, 0x9, 0x6],
        'K': [0x9, 0xa, 0xc, 0xa, 0x9],
        'L': [0x8, 0x8, 0x8, 0x8, 0xf],
        'M': [0x9, 0xf, 0xf, 0x9, 0x9],
        'N': [0x9, 0xd, 0xf, 0xb, 0x9],
        'O': [0x6, 0x9, 0x9, 0x9, 0x6],
        'P': [0xe, 0x9, 0xe, 0x8, 0x8],
        'Q': [0x6, 0x9, 0x9, 0xb, 0x7],
        'R': [0xe, 0x9, 0xe, 0xa, 0x9],
        'S': [0x7, 0x8, 0x6, 0x1, 0xe],
        'T': [0xe, 0x4, 0x4, 0x4, 0x4],
        'U': [0x9, 0x9, 0x9, 0x9, 0x6],
        'V': [0x9, 0x9, 0x9, 0x6, 0x6],
        'W': [0x9, 0x9, 0xf, 0xf, 0x9],
        'X': [0x9, 0x9, 0x6, 0x9, 0x9],
        'Y': [0x9, 0x5, 0x2, 0x2, 0x2],
        'Z': [0xf, 0x2, 0x4, 0x8, 0xf],
        '[': [0xe, 0x8, 0x8, 0x8, 0xe],
        '\\': [0x8, 0x8, 0x4, 0x2, 0x1],
        ']': [0x7, 0x1, 0x1, 0x1, 0x7],
        '^': [0x4, 0xa, 0x0, 0x0, 0x0],
        '_': [0x0, 0x0, 0x0, 0x0, 0xf],
        '`': [0x4, 0x2, 0x0, 0x0, 0x0],
        'a': [0x0, 0x5, 0xb, 0xb, 0x5],
        'b': [0x8, 0x8, 0xe, 0x9, 0xe],
        'c': [0x0, 0x7, 0x8, 0x8, 0x7],
        'd': [0x1, 0x1, 0x7, 0x9, 0x7],
        'e': [0x0, 0x6, 0xf, 0x8, 0x7],
        'f': [0x3, 0x4, 0xe, 0x4, 0x4],
        'g': [0x7, 0x9, 0x7, 0x1, 0x7],
        'h': [0x8, 0x8, 0xe, 0x9, 0x9],
        'i': [0x0, 0x2, 0x0, 0x2, 0x2],
        'j': [0x1, 0x0, 0x1, 0x1, 0x6],
        'k': [0x8, 0xa, 0xc, 0xa, 0x9],
        'l': [0xc, 0x4, 0x4, 0x4, 0xe],
        'm': [0x0, 0x9, 0xf, 0xf, 0x9],
        'n': [0x0, 0xe, 0x9, 0x9, 0x9],
        'o': [0x0, 0x6, 0x9, 0x9, 0x6],
        'p': [0x0, 0xe, 0x9, 0xe, 0x8],
        'q': [0x0, 0x6, 0x9, 0x7, 0x1],
        'r': [0x0, 0xb, 0xc, 0x8, 0x8],
        's': [0x0, 0x7, 0x4, 0x2, 0xe],
        't': [0x4, 0xe, 0x4, 0x4, 0x3],
        'u': [0x0, 0x9, 0x9, 0x9, 0x6],
        'v': [0x0, 0x9, 0x9, 0x6, 0x6],
        'w': [0x0, 0x9, 0xf, 0xf, 0x6],
        'x': [0x0, 0x9, 0x6, 0x6, 0x9],
        'y': [0x0, 0x9, 0x7, 0x1, 0x6],
        'z': [0x0, 0xf, 0x2, 0x4, 0xf],
        '{': [0x6, 0x4, 0xc, 0x4, 0x6],
        '|': [0x4, 0x4, 0x0, 0x4, 0x4],
        '}': [0xc, 0x4, 0x6, 0x4, 0xc],
        '~': [0x0, 0x0, 0x5, 0xa, 0x0],
    }

    def get_char_map(self, character):
        return self.char_map[character]


class BlockFont(Font):
    """A block font based based on the Minecraftia font.

        http://www.dafont.com/minecraftia.font

    """

    char_height = 8
    char_width = 5

    char_map = {
        ' ': [0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],
        '!': [0x8,0x8,0x8,0x8,0x8,0x0,0x8,0x0],
        '"': [0x0,0xa,0xa,0x0,0x0,0x0,0x0,0x0],
        '#': [0xa,0xa,0x1f,0xa,0x1f,0xa,0xa,0x0],
        '$': [0x4,0xf,0x10,0xe,0x1,0x1e,0x4,0x0],
        '£': [0x7,0x8,0x8,0x1e,0x8,0x8,0x1f,0x0],
        '%': [0x11,0x12,0x2,0x4,0x8,0x9,0x11,0x0],
        '&': [0x4,0xa,0x4,0xd,0x12,0x12,0xd,0x0],
        '\'': [0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0],
        '(': [0x6,0x8,0x10,0x10,0x10,0x8,0x6,0x0],
        ')': [0x18,0x4,0x2,0x2,0x2,0x4,0x18,0x0],
        '*': [0x0,0x0,0x15,0xe,0x1f,0xe,0x15,0x0],
        '+': [0x0,0x0,0x4,0x4,0x1f,0x4,0x4,0x0],
        '÷': [0x0,0x4,0x0,0x1f,0x0,0x4,0x0,0x0],
        ',': [0x0,0x0,0x0,0x0,0x8,0x8,0x8,0x0],
        '-': [0x0,0x0,0x0,0xe,0x0,0x0,0x0,0x0],
        '.': [0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0],
        '/': [0x1,0x2,0x2,0x4,0x8,0x8,0x10,0x0],
        '0': [0xe,0x11,0x13,0x15,0x19,0x11,0xe,0x0],
        '1': [0x4,0xc,0x4,0x4,0x4,0x4,0x1f,0x0],
        '2': [0xe,0x11,0x1,0x6,0x8,0x10,0x1f,0x0],
        '3': [0xe,0x11,0x1,0x6,0x1,0x11,0xe,0x0],
        '4': [0x3,0x5,0x9,0x11,0x1f,0x1,0x1,0x0],
        '5': [0x1f,0x10,0x1e,0x1,0x1,0x11,0xe,0x0],
        '6': [0x6,0x8,0x10,0x1e,0x11,0x11,0xe,0x0],
        '7': [0x1f,0x11,0x1,0x2,0x4,0x4,0x4,0x0],
        '8': [0xe,0x11,0x11,0xe,0x11,0x11,0xe,0x0],
        '9': [0xe,0x11,0x11,0xf,0x1,0x2,0xc,0x0],
        ':': [0x0,0x4,0x4,0x0,0x4,0x4,0x0,0x0],
        ';': [0x0,0x4,0x4,0x0,0x4,0x4,0x4,0x0],
        '<': [0x2,0x4,0x8,0x10,0x8,0x4,0x2,0x0],
        '=': [0x0,0x0,0x1f,0x0,0x0,0x1f,0x0,0x0],
        '>': [0x10,0x8,0x4,0x2,0x4,0x8,0x10,0x0],
        '?': [0xe,0x11,0x1,0x2,0x4,0x0,0x4,0x0],
        '@': [0xe,0x11,0x17,0x15,0x17,0x10,0xf,0x0],
        'A': [0xe,0x11,0x1f,0x11,0x11,0x11,0x11,0x0],
        'B': [0x1e,0x11,0x1e,0x11,0x11,0x11,0x1e,0x0],
        'C': [0xe,0x11,0x10,0x10,0x10,0x11,0xe,0x0],
        'D': [0x1e,0x11,0x11,0x11,0x11,0x11,0x1e,0x0],
        'E': [0x1f,0x10,0x1c,0x10,0x10,0x10,0x1f,0x0],
        'F': [0x1f,0x10,0x1c,0x10,0x10,0x10,0x10,0x0],
        'G': [0xf,0x10,0x17,0x11,0x11,0x11,0xe,0x0],
        'H': [0x11,0x11,0x1f,0x11,0x11,0x11,0x11,0x0],
        'I': [0xe,0x4,0x4,0x4,0x4,0x4,0xe,0x0],
        'J': [0x1,0x1,0x1,0x1,0x1,0x11,0xe,0x0],
        'K': [0x11,0x12,0x1c,0x12,0x11,0x11,0x11,0x0],
        'L': [0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x0],
        'M': [0x11,0x1b,0x15,0x11,0x11,0x11,0x11,0x0],
        'N': [0x11,0x19,0x15,0x13,0x11,0x11,0x11,0x0],
        'O': [0xe,0x11,0x11,0x11,0x11,0x11,0xe,0x0],
        'P': [0x1e,0x11,0x1f,0x10,0x10,0x10,0x10,0x0],
        'Q': [0xe,0x11,0x11,0x11,0x11,0x12,0xd,0x0],
        'R': [0x1e,0x11,0x1e,0x11,0x11,0x11,0x11,0x0],
        'S': [0xf,0x10,0xe,0x1,0x1,0x11,0xe,0x0],
        'T': [0x1f,0x4,0x4,0x4,0x4,0x4,0x4,0x0],
        'U': [0x11,0x11,0x11,0x11,0x11,0x11,0xe,0x0],
        'V': [0x11,0x11,0x11,0x11,0xa,0xa,0x4,0x0],
        'W': [0x11,0x11,0x11,0x11,0x15,0x1b,0x11,0x0],
        'X': [0x11,0xa,0x4,0xa,0x11,0x11,0x11,0x0],
        'Y': [0x11,0xa,0x4,0x4,0x4,0x4,0x4,0x0],
        'Z': [0x1f,0x1,0x2,0x4,0x8,0x10,0x1f,0x0],
        '[': [0x1c,0x10,0x10,0x10,0x10,0x10,0x1c,0x0],
        '\\': [ 0x10,0x8,0x8,0x4,0x2,0x2,0x1,0x0],
        ']': [0x1c,0x4,0x4,0x4,0x4,0x4,0x1c,0x0],
        '^': [0x4,0xa,0x11,0x0,0x0,0x0,0x0,0x0],
        '_': [0x0,0x0,0x0,0x0,0x0,0x0,0x1e,0x0],
        '`': [0x0,0x8,0x4,0x0,0x0,0x0,0x0,0x0],
        'a': [0x0,0x0,0xe,0x1,0xf,0x11,0xf,0x0],
        'b': [0x10,0x10,0x16,0x19,0x11,0x11,0x1e,0x0],
        'c': [0x0,0x0,0xe,0x11,0x10,0x11,0xe,0x0],
        'd': [0x1,0x1,0xd,0x13,0x11,0x11,0xf,0x0],
        'e': [0x0,0x0,0xe,0x11,0x1f,0x10,0xf,0x0],
        'f': [0x0,0x6,0x8,0x1e,0x8,0x8,0x8,0x0],
        'g': [0x0,0x0,0xf,0x11,0x11,0xf,0x1,0x1e],
        'h': [0x10,0x10,0x16,0x19,0x11,0x11,0x11,0x0],
        'i': [0x4,0x0,0x4,0x4,0x4,0x4,0x4,0x0],
        'j': [0x1,0x0,0x1,0x1,0x11,0x11,0xe,0x0],
        'k': [0x10,0x10,0x12,0x14,0x18,0x14,0x12,0x0],
        'l': [0x8,0x8,0x8,0x8,0x8,0x8,0x4,0x0],
        'm': [0x0,0x0,0x1a,0x15,0x15,0x11,0x11,0x0],
        'n': [0x0,0x0,0x1e,0x11,0x11,0x11,0x11,0x0],
        'o': [0x0,0x0,0xe,0x11,0x11,0x11,0xe,0x0],
        'p': [0x0,0x0,0x16,0x19,0x11,0x1e,0x10,0x10],
        'q': [0x0,0x0,0xd,0x13,0x11,0xf,0x1,0x1],
        'r': [0x0,0x0,0x16,0x19,0x10,0x10,0x10,0x0],
        's': [0x0,0x0,0xf,0x10,0xe,0x1,0x1e,0x0],
        't': [0x0,0x4,0xe,0x4,0x4,0x4,0x2,0x0],
        'u': [0x0,0x0,0x11,0x11,0x11,0x11,0xf,0x0],
        'v': [0x0,0x0,0x11,0x11,0x11,0xa,0x4,0x0],
        'w': [0x0,0x0,0x11,0x11,0x15,0x15,0xf,0x0],
        'x': [0x0,0x0,0x11,0xa,0x4,0xa,0x11,0x0],
        'y': [0x0,0x0,0x11,0x11,0x11,0xf,0x1,0x1e],
        'z': [0x0,0x0,0x1f,0x2,0x4,0x8,0x1f,0x0],
        '{': [0x6,0x8,0x8,0x10,0x8,0x8,0x6,0x0],
        '|': [0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x0],
        '}': [0x18,0x4,0x4,0x2,0x4,0x4,0x18,0x0],
        '~': [0x0,0x0,0xd,0x12,0x0,0x0,0x0,0x0],
        '°': [0xe,0xa,0xe,0x0,0x0,0x0,0x0,0x0],
    }

    def get_char_map(self, character):
        return self.char_map[character]
