# Midscene Python Wiki

欢迎来到 Midscene Python 的完整文档！这里提供了详细的使用指南、API 参考和最佳实践。

## 📚 文档导航

### 基础入门
- [项目概述](项目概述.md) - 了解 Midscene Python 的核心理念和特性
- [快速开始](快速开始.md) - 5分钟快速上手指南
- [安装配置](安装配置.md) - 详细的安装和环境配置说明

### 核心概念
- [Agent 核心控制器](核心概念/Agent核心控制器.md) - 理解 Agent 的工作原理
- [Insight UI理解引擎](核心概念/Insight-UI理解引擎.md) - AI 驱动的 UI 理解和操作
- [AI模型服务抽象层](核心概念/AI模型服务抽象层.md) - 多种 AI 模型的统一接口
- [UI上下文与数据模型](核心概念/UI上下文与数据模型.md) - 理解数据流和上下文管理

### API 参考
- [Agent API](API参考/Agent-API.md) - Agent 类的完整 API 文档
- [Insight API](API参考/Insight-API.md) - Insight 引擎的 API 参考
- [AIModelService API](API参考/AIModelService-API.md) - AI 模型服务的接口说明

### 平台集成
- [Web自动化](平台集成/Web自动化/README.md) - Web 平台自动化完整指南
  - [Selenium集成](平台集成/Web自动化/Selenium集成.md) - Selenium WebDriver 集成
  - [Playwright集成](平台集成/Web自动化/Playwright集成.md) - Playwright 集成指南
  - [Web桥接机制](平台集成/Web自动化/Web桥接机制.md) - 统一的 Web 操作抽象层
- [Android自动化](平台集成/Android自动化.md) - Android 设备自动化指南

### AI 模型配置
- [配置方法](AI模型配置/配置方法.md) - AI 模型的基础配置
- [支持的AI提供商](AI模型配置/支持的AI提供商/README.md) - 所有支持的 AI 服务商
  - [OpenAI提供商](AI模型配置/支持的AI提供商/OpenAI提供商.md) - GPT-4V 等模型配置
  - [Anthropic提供商](AI模型配置/支持的AI提供商/Anthropic提供商.md) - Claude 模型配置
  - [通义千问提供商](AI模型配置/支持的AI提供商/通义千问提供商.md) - Qwen2.5-VL 模型配置
  - [Gemini提供商](AI模型配置/支持的AI提供商/Gemini提供商.md) - Google Gemini 模型配置
- [高级选项](AI模型配置/高级选项/README.md) - 高级配置和优化
  - [缓存策略](AI模型配置/高级选项/缓存策略.md) - 智能缓存机制
  - [请求重试与超时控制](AI模型配置/高级选项/请求重试与超时控制.md) - 网络请求优化
  - [配额管理与节流控制](AI模型配置/高级选项/配额管理与节流控制.md) - 成本控制和速率限制
  - [流式响应处理](AI模型配置/高级选项/流式响应处理.md) - 实时响应处理
  - [性能调优技巧](AI模型配置/高级选项/性能调优技巧.md) - 性能优化最佳实践

### 高级特性
- [智能缓存机制](高级特性/智能缓存机制.md) - 提升执行效率的缓存系统
- [可视化报告系统](高级特性/可视化报告系统.md) - 详细的执行报告和调试信息
- [CLI工具高级用法](高级特性/CLI工具高级用法.md) - 命令行工具的进阶使用

### 开发指南
- [贡献指南](开发指南/贡献指南.md) - 如何参与项目开发
- [架构设计](开发指南/架构设计.md) - 深入理解项目架构
- [开发环境配置](开发指南/开发环境配置.md) - 搭建开发环境
- [测试指南](开发指南/测试指南.md) - 单元测试和集成测试

### 故障排除
- [常见问题](故障排除/常见问题.md) - FAQ 和解决方案
- [调试技巧](故障排除/调试技巧.md) - 调试和问题定位方法
- [错误代码参考](故障排除/错误代码参考.md) - 错误代码含义和解决方案

### 示例和教程
- [基础示例](示例和教程/基础示例.md) - 入门级使用示例
- [高级应用场景](示例和教程/高级应用场景.md) - 复杂场景的实现方案
- [最佳实践](示例和教程/最佳实践.md) - 生产环境使用建议

## 🚀 快速链接

- **新手入门**: [快速开始](快速开始.md) → [基础示例](示例和教程/基础示例.md)
- **API 查询**: [Agent API](API参考/Agent-API.md) → [Insight API](API参考/Insight-API.md)
- **平台集成**: [Web自动化](平台集成/Web自动化/README.md) → [Android自动化](平台集成/Android自动化.md)
- **问题解决**: [常见问题](故障排除/常见问题.md) → [调试技巧](故障排除/调试技巧.md)

## 📖 文档维护

本文档随项目持续更新，如发现内容错误或需要补充，请提交 Issue 或 Pull Request。

---

*最后更新: 2025-09-02*