from setuptools import setup, find_packages
from pathlib import Path
this_directory = Path(__file__).parent
long_description = (this_directory / "Readme.md").read_text()

setup(
    name='MilPython',
    version='0.0.5',
    description='Framework for building MILP optimizations for time series with gurobipy',
    license='MIT',
    packages=find_packages(),
    long_description=long_description,
    long_description_content_type='text/markdown',
    author='Hannes Hanse',
    author_email='hannes.hanse@tu-clausthal.de',
    keywords=['milp','time series','optimization','gurobi','gurobipy'],
    readme = "README.md",
    url='https://github.com/hanneshanse/MilPython',
    install_requires=["scipy","gurobipy","numpy","matplotlib"],
    classifiers = [
    "Programming Language :: Python :: 3",
    "License :: OSI Approved :: MIT License",
    "Operating System :: OS Independent",
]
)