## Minecraft: Python Edition

![Minecraft](/screenshot.png?raw=true)

_**Minecraft: Python Edition**_ is a project that strives to recreate each and every old Minecraft version in Python 3 using the **Pyglet** multimedia library and **Cython** for performance.

The project is currently working on the Indev versions of Minecraft.
The latest version is **Indev 0.31 20100128** as released on _**January 28, 2010**_.

This version adds diamonds, diamond ore, gears, metal tool variants, and semi-functional crafting to the game.

Features from previous Indev versions include the Indev mossy cobblestone spawn house which contains chests
with all of the items available in this version, NBT level file saving,
tools including flint and steel and the bow and arrow, torches, advanced liquid spread, TNT explosives, and the MD3 Rana mobs.

To easily install this version of *Minecraft: Python Edition*, just run `python -m pip install minecraft-python==0.31.20100128`.

You can learn more about this version [on the Minecraft wiki.](https://minecraft.wiki/w/Java_Edition_Indev_0.31_20100128)

### Organization

This project's commits represent the Python versions of each Minecraft Java game version.
You can view source code changes between game versions by checking the commit history or comparing branches.
To play any version, specify it in the `pip install` command as demonstrated below.

### General Usage

*Pyglet*, *Cython*, *Pillow*, *PyOgg*, *NumPy*, and *nbtlib* are required dependencies which can easily be installed with *pip*. Use the versions specified in `requirements.txt`.
*wxPython* is an optional dependency for the level file picker, but if you don't have it then *Tkinter* is used instead.

For audio to work you will either need *PyOgg* which is recommended, or *FFmpeg* which has to be installed on your system.
*GStreamer* is also supported on Linux through the *gst-python* library.
PyOgg requires that your system have one of the Opus, FLAC, or Vorbis codecs.
*OpenAL* is required and comes bundled with the source on Windows.

For a manual Cython source build, run `python setup.py build_ext --inplace`.

Run `python -m mc.net.minecraft.client.Minecraft` to launch the game. *Minecraft: Python Edition* should be compatible with any modern platform that supports OpenGL and Cython.

Run with the argument `-fullscreen` to open the window in fullscreen mode (or press F11 in-game).
The argument `-creative` will force the game to be in creative mode.

### Gameplay

All available tools and blocks are in the chests in the spawn house.
All controls are as you would expect for the game and they can be configured in the options menu.
Press I to open your inventory, B to craft (only recipe is an apple in the top-left corner for an arrow),
F5 to toggle rain and F7 to take a cool isometric screenshot.

The Indev level generator is customizable and you can choose between the *Inland*, *Island*, *Floating*, and *Flat* level types.
You can specify the world theme as *Normal* or *Hell* (lava and dirt instead of water and grass), world size, and world shape (*Square*, *Long*, *Deep*).

Levels can be saved to a single *.mclevel* NBT file in the pause menu. The level files are perfectly compatible with Java and vice versa.

The only mobs around are the Ranas, but they don't drop anything when killed. Apples will restore health.

![Isometric screenshot](/map.png?raw=true)

*An isometric screenshot of a deep Floating map generated by the game.*

### Additional Notes

The `mc.resources` directory contains all of the textures and sounds that this version uses. However,
the textures are only there for convenience, as all of the texture buffers are already preloaded
in the `mc.Resources` module.

This would have been much more challenging to work on without the great tools provided by [RetroMCP-Java](https://github.com/MCPHackers/RetroMCP-Java).
