# ----
# This file is generated by mini_lambda_methods_generation.py - do not modify it !
# ----
try:  # python 3.5+
    from typing import Any
except ImportError:
    pass

from math import trunc
from mini_lambda.base import _LambdaExpressionBase, evaluate, get_repr, FunctionDefinitionError,     _get_root_var
from mini_lambda.base import _PRECEDENCE_ADD_SUB, _PRECEDENCE_MUL_DIV_ETC, _PRECEDENCE_COMPARISON,     _PRECEDENCE_EXPONENTIATION, _PRECEDENCE_SHIFTS, _PRECEDENCE_POS_NEG_BITWISE_NOT,     _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF


class _LambdaExpressionGenerated(_LambdaExpressionBase):
    """
    This generated class implements a bunch of magic methods, so that calling these magic methods on an object will
    result in adding that magic method to the _LambdaExpressionBase's stack.
    This allows for example x[1] to return a new _LambdaExpressionGenerated whose stack is able to call [1] (getitem(1))
    on the result of the current stack's evaluation

    The methods added below belong to two categories
     * All magic methods that 'just' need to be implemented (for example __add__), or remapped to the original method
     calling them because on some built-in data types the magic method does not exist (for example, __getattr__ should
     not add __getattr__ to the stack but getattr)
     * All magic methods that do not work because the python framework does not allow them to return another type than
     the expected one. For all of them there are two methods: one in the class throwing an exception, and one at
     package-level to provide a replacement (The exception message provides the replacement method name).
    """

    # ******* All magic methods that need to be implemented ********

    def __next__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'next(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___next__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return next(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('next(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=___next__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def next(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'next(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def _next(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return next(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('next(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=_next, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __lt__(self, other):
        """ Returns a new _LambdaExpression performing '<r> < other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___lt__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r < evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_COMPARISON) + ' < ' + get_repr(other, _PRECEDENCE_COMPARISON)
        return type(self)(fun=___lt__, precedence_level=_PRECEDENCE_COMPARISON, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __le__(self, other):
        """ Returns a new _LambdaExpression performing '<r> <= other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___le__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r <= evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_COMPARISON) + ' <= ' + get_repr(other, _PRECEDENCE_COMPARISON)
        return type(self)(fun=___le__, precedence_level=_PRECEDENCE_COMPARISON, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __eq__(self, other):
        """ Returns a new _LambdaExpression performing '<r> == other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___eq__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r == evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_COMPARISON) + ' == ' + get_repr(other, _PRECEDENCE_COMPARISON)
        return type(self)(fun=___eq__, precedence_level=_PRECEDENCE_COMPARISON, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __ne__(self, other):
        """ Returns a new _LambdaExpression performing '<r> != other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___ne__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r != evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_COMPARISON) + ' != ' + get_repr(other, _PRECEDENCE_COMPARISON)
        return type(self)(fun=___ne__, precedence_level=_PRECEDENCE_COMPARISON, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __gt__(self, other):
        """ Returns a new _LambdaExpression performing '<r> > other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___gt__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r > evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_COMPARISON) + ' > ' + get_repr(other, _PRECEDENCE_COMPARISON)
        return type(self)(fun=___gt__, precedence_level=_PRECEDENCE_COMPARISON, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __ge__(self, other):
        """ Returns a new _LambdaExpression performing '<r> >= other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___ge__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r >= evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_COMPARISON) + ' >= ' + get_repr(other, _PRECEDENCE_COMPARISON)
        return type(self)(fun=___ge__, precedence_level=_PRECEDENCE_COMPARISON, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __getattr__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'getattr(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___getattr__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return getattr(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('getattr(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=___getattr__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __call__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__call__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__call__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___call__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__call__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__call__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___call__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __reversed__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'reversed(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___reversed__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return reversed(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('reversed(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=___reversed__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __getitem__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__getitem__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__getitem__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___getitem__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__getitem__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__getitem__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___getitem__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __missing__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__missing__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__missing__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___missing__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__missing__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__missing__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___missing__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __add__(self, other):
        """ Returns a new _LambdaExpression performing '<r> + other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___add__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r + evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_ADD_SUB) + ' + ' + get_repr(other, _PRECEDENCE_ADD_SUB)
        return type(self)(fun=___add__, precedence_level=_PRECEDENCE_ADD_SUB, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __radd__(self, other):
        """ Returns a new _LambdaExpression performing 'other + <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___radd__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) + r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_ADD_SUB) + ' + ' + get_repr(self, _PRECEDENCE_ADD_SUB)
        return type(self)(fun=___radd__, precedence_level=_PRECEDENCE_ADD_SUB, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __sub__(self, other):
        """ Returns a new _LambdaExpression performing '<r> - other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___sub__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r - evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_ADD_SUB) + ' - ' + get_repr(other, _PRECEDENCE_ADD_SUB)
        return type(self)(fun=___sub__, precedence_level=_PRECEDENCE_ADD_SUB, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rsub__(self, other):
        """ Returns a new _LambdaExpression performing 'other - <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rsub__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) - r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_ADD_SUB) + ' - ' + get_repr(self, _PRECEDENCE_ADD_SUB)
        return type(self)(fun=___rsub__, precedence_level=_PRECEDENCE_ADD_SUB, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __mul__(self, other):
        """ Returns a new _LambdaExpression performing '<r> * other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___mul__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r * evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_MUL_DIV_ETC) + ' * ' + get_repr(other, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___mul__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rmul__(self, other):
        """ Returns a new _LambdaExpression performing 'other * <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rmul__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) * r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_MUL_DIV_ETC) + ' * ' + get_repr(self, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___rmul__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __truediv__(self, other):
        """ Returns a new _LambdaExpression performing '<r> / other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___truediv__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r / evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_MUL_DIV_ETC) + ' / ' + get_repr(other, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___truediv__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rtruediv__(self, other):
        """ Returns a new _LambdaExpression performing 'other / <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rtruediv__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) / r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_MUL_DIV_ETC) + ' / ' + get_repr(self, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___rtruediv__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __mod__(self, other):
        """ Returns a new _LambdaExpression performing '<r> % other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___mod__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r % evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_MUL_DIV_ETC) + ' % ' + get_repr(other, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___mod__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rmod__(self, other):
        """ Returns a new _LambdaExpression performing 'other % <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rmod__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) % r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_MUL_DIV_ETC) + ' % ' + get_repr(self, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___rmod__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __divmod__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__divmod__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__divmod__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___divmod__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__divmod__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__divmod__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___divmod__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __rdivmod__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__rdivmod__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__rdivmod__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___rdivmod__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__rdivmod__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__rdivmod__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___rdivmod__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __pow__(self, other):
        """ Returns a new _LambdaExpression performing '<r> ** other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___pow__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r ** evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_EXPONENTIATION) + ' ** ' + get_repr(other, _PRECEDENCE_EXPONENTIATION)
        return type(self)(fun=___pow__, precedence_level=_PRECEDENCE_EXPONENTIATION, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rpow__(self, other):
        """ Returns a new _LambdaExpression performing 'other ** <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rpow__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) ** r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_EXPONENTIATION) + ' ** ' + get_repr(self, _PRECEDENCE_EXPONENTIATION)
        return type(self)(fun=___rpow__, precedence_level=_PRECEDENCE_EXPONENTIATION, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __matmul__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__matmul__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__matmul__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___matmul__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__matmul__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__matmul__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___matmul__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __div__(self, other):
        """ Returns a new _LambdaExpression performing '<r> / other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___div__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r / evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_MUL_DIV_ETC) + ' / ' + get_repr(other, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___div__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rdiv__(self, other):
        """ Returns a new _LambdaExpression performing 'other / <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rdiv__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) / r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_MUL_DIV_ETC) + ' / ' + get_repr(self, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___rdiv__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __floordiv__(self, other):
        """ Returns a new _LambdaExpression performing '<r> // other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___floordiv__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r // evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_MUL_DIV_ETC) + ' // ' + get_repr(other, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___floordiv__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rfloordiv__(self, other):
        """ Returns a new _LambdaExpression performing 'other // <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rfloordiv__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) // r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_MUL_DIV_ETC) + ' // ' + get_repr(self, _PRECEDENCE_MUL_DIV_ETC)
        return type(self)(fun=___rfloordiv__, precedence_level=_PRECEDENCE_MUL_DIV_ETC, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __lshift__(self, other):
        """ Returns a new _LambdaExpression performing '<r> << other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___lshift__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r << evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_SHIFTS) + ' << ' + get_repr(other, _PRECEDENCE_SHIFTS)
        return type(self)(fun=___lshift__, precedence_level=_PRECEDENCE_SHIFTS, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rlshift__(self, other):
        """ Returns a new _LambdaExpression performing 'other << <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rlshift__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) << r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_SHIFTS) + ' << ' + get_repr(self, _PRECEDENCE_SHIFTS)
        return type(self)(fun=___rlshift__, precedence_level=_PRECEDENCE_SHIFTS, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rshift__(self, other):
        """ Returns a new _LambdaExpression performing '<r> >> other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rshift__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r >> evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_SHIFTS) + ' >> ' + get_repr(other, _PRECEDENCE_SHIFTS)
        return type(self)(fun=___rshift__, precedence_level=_PRECEDENCE_SHIFTS, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rrshift__(self, other):
        """ Returns a new _LambdaExpression performing 'other >> <r>' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rrshift__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return evaluate(other, input) >> r

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(other, _PRECEDENCE_SHIFTS) + ' >> ' + get_repr(self, _PRECEDENCE_SHIFTS)
        return type(self)(fun=___rrshift__, precedence_level=_PRECEDENCE_SHIFTS, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rshift__(self, other):
        """ Returns a new _LambdaExpression performing '<r> >> other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rshift__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r >> evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_SHIFTS) + ' >> ' + get_repr(other, _PRECEDENCE_SHIFTS)
        return type(self)(fun=___rshift__, precedence_level=_PRECEDENCE_SHIFTS, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __rshift__(self, other):
        """ Returns a new _LambdaExpression performing '<r> >> other' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, other)
        def ___rshift__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r >> evaluate(other, input)

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = get_repr(self, _PRECEDENCE_SHIFTS) + ' >> ' + get_repr(other, _PRECEDENCE_SHIFTS)
        return type(self)(fun=___rshift__, precedence_level=_PRECEDENCE_SHIFTS, str_expr=string_expr,
                          root_var=root_var, repr_on=self.repr_on)

    def __neg__(self):
        """ Returns a new _LambdaExpression performing '-<r>' on the result <r> of this evaluator's evaluation """
        def ___neg__(input):
            # first evaluate the inner function
            res = self.evaluate(input)
            # then call the method
            return -res

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = '-' + get_repr(self, _PRECEDENCE_POS_NEG_BITWISE_NOT)
        return type(self)(fun=___neg__, precedence_level=_PRECEDENCE_POS_NEG_BITWISE_NOT, str_expr=string_expr, root_var=self._root_var, repr_on=self.repr_on)

    def __pos__(self):
        """ Returns a new _LambdaExpression performing '+<r>' on the result <r> of this evaluator's evaluation """
        def ___pos__(input):
            # first evaluate the inner function
            res = self.evaluate(input)
            # then call the method
            return +res

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = '+' + get_repr(self, _PRECEDENCE_POS_NEG_BITWISE_NOT)
        return type(self)(fun=___pos__, precedence_level=_PRECEDENCE_POS_NEG_BITWISE_NOT, str_expr=string_expr, root_var=self._root_var, repr_on=self.repr_on)

    def __abs__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'abs(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___abs__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return abs(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('abs(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=___abs__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __invert__(self):
        """ Returns a new _LambdaExpression performing '~<r>' on the result <r> of this evaluator's evaluation """
        def ___invert__(input):
            # first evaluate the inner function
            res = self.evaluate(input)
            # then call the method
            return ~res

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        string_expr = '~' + get_repr(self, _PRECEDENCE_POS_NEG_BITWISE_NOT)
        return type(self)(fun=___invert__, precedence_level=_PRECEDENCE_POS_NEG_BITWISE_NOT, str_expr=string_expr, root_var=self._root_var, repr_on=self.repr_on)

    def __round__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'round(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___round__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return round(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('round(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=___round__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __trunc__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing 'trunc(<r>, *args, **kwargs)' on the result <r> of this evaluator's evaluation """
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___trunc__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return trunc(r, *[evaluate(other, input) for other in args],
                                                **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = ('trunc(' + get_repr(self, None)
                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')
                       + ', '.join([get_repr(arg, None) for arg in args])
                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])
                       + ')')
        return type(self)(fun=___trunc__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    def __coerce__(self, *args, **kwargs):
        """ Returns a new _LambdaExpression performing '<r>.__coerce__(*args, **kwargs)' on the result <r> of this evaluator's evaluation """
        # return self.add_bound_method_to_stack('__coerce__', *args, **kwargs)
        root_var, _ = _get_root_var(self, *args, **kwargs)
        def ___coerce__(input):
            # first evaluate the inner function
            r = self.evaluate(input)
            # then call the method
            return r.__coerce__(*[evaluate(other, input) for other in args],
                                      **{arg_name: evaluate(other, input) for arg_name, other in kwargs.items()})

        # return a new LambdaExpression of the same type than self, with the new function as inner function
        # Note: we use precedence=None for coma-separated items inside the parenthesis
        string_expr = get_repr(self, _PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF) + '.__coerce__('                       + ', '.join([get_repr(arg, None) for arg in args])                       + (', ' if (len(args) > 0 and len(kwargs) > 0) else '')                       + ', '.join([arg_name + '=' + get_repr(arg, None) for arg_name, arg in kwargs.items()])                       + ')'
        return type(self)(fun=___coerce__, precedence_level=_PRECEDENCE_SUBSCRIPTION_SLICING_CALL_ATTRREF,
                          str_expr=string_expr, root_var=root_var, repr_on=self.repr_on)

    # ******* All magic methods that need to raise an exception ********
    def __iter__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__iter__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Iter() method provided at mini_lambda package'
                                      ' level instead. If you did not use __iter__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __str__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__str__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Str() method provided at mini_lambda package'
                                      ' level instead. If you did not use __str__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __bytes__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__bytes__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Bytes() method provided at mini_lambda package'
                                      ' level instead. If you did not use __bytes__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __format__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__format__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Format() method provided at mini_lambda package'
                                      ' level instead. If you did not use __format__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __sizeof__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__sizeof__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Sizeof() method provided at mini_lambda package'
                                      ' level instead. If you did not use __sizeof__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __hash__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__hash__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Hash() method provided at mini_lambda package'
                                      ' level instead. If you did not use __hash__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __bool__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__bool__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Bool() method provided at mini_lambda package'
                                      ' level instead. If you did not use __bool__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __len__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__len__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Len() method provided at mini_lambda package'
                                      ' level instead. If you did not use __len__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __int__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__int__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Int() method provided at mini_lambda package'
                                      ' level instead. If you did not use __int__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __float__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__float__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Float() method provided at mini_lambda package'
                                      ' level instead. If you did not use __float__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __complex__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__complex__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Complex() method provided at mini_lambda package'
                                      ' level instead. If you did not use __complex__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __oct__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__oct__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Oct() method provided at mini_lambda package'
                                      ' level instead. If you did not use __oct__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

    def __hex__(self, *args, **kwargs):
        """
        This magic method can not be used on an _LambdaExpression, because unfortunately python checks the
        result type and does not allow it to be a custom type.
        """
        raise FunctionDefinitionError('__hex__ is not supported by mini-lambda expressions, since python '
                                      'raises an'
                                      ' error when its output is not directly an object of the type it expects.'
                                      'Please use the Hex() method provided at mini_lambda package'
                                      ' level instead. If you did not use __hex__ in your expression, you '
                                      'probably used a standard method such as math.log(x) instead of a method '
                                      ' converted to mini_lambda such as Log(x). Please check the documentation for '
                                      'details.')

