"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class AvailableProvidersTypedDict(TypedDict):
    display_name: NotRequired[str]
    r"""User-friendly provider name"""
    models: NotRequired[List[str]]
    r"""Available models from this provider"""


class AvailableProviders(BaseModel):
    display_name: Optional[str] = None
    r"""User-friendly provider name"""

    models: Optional[List[str]] = None
    r"""Available models from this provider"""


class GetPreferencesPreferencesTypedDict(TypedDict):
    r"""User preferences (null if no preferences exist)"""

    created_at: NotRequired[int]
    r"""Unix timestamp when preferences were created"""
    main_agent_max_tokens: NotRequired[int]
    r"""Maximum tokens for main agent responses"""
    main_agent_model: NotRequired[str]
    r"""Main agent model ID"""
    main_agent_reasoning_effort: NotRequired[str]
    r"""Reasoning effort setting for main agent"""
    preferred_provider: NotRequired[str]
    r"""Preferred AI provider (anthropic, openai, openrouter)"""
    sub_agent_max_tokens: NotRequired[int]
    r"""Maximum tokens for sub agent responses"""
    sub_agent_model: NotRequired[str]
    r"""Sub agent model ID"""
    sub_agent_reasoning_effort: NotRequired[str]
    r"""Reasoning effort setting for sub agent"""
    updated_at: NotRequired[int]
    r"""Unix timestamp of last update"""


class GetPreferencesPreferences(BaseModel):
    r"""User preferences (null if no preferences exist)"""

    created_at: Optional[int] = None
    r"""Unix timestamp when preferences were created"""

    main_agent_max_tokens: Optional[int] = None
    r"""Maximum tokens for main agent responses"""

    main_agent_model: Optional[str] = None
    r"""Main agent model ID"""

    main_agent_reasoning_effort: Optional[str] = None
    r"""Reasoning effort setting for main agent"""

    preferred_provider: Optional[str] = None
    r"""Preferred AI provider (anthropic, openai, openrouter)"""

    sub_agent_max_tokens: Optional[int] = None
    r"""Maximum tokens for sub agent responses"""

    sub_agent_model: Optional[str] = None
    r"""Sub agent model ID"""

    sub_agent_reasoning_effort: Optional[str] = None
    r"""Reasoning effort setting for sub agent"""

    updated_at: Optional[int] = None
    r"""Unix timestamp of last update"""


class GetPreferencesResponseTypedDict(TypedDict):
    r"""User preferences and available providers"""

    available_providers: Dict[str, AvailableProvidersTypedDict]
    r"""Map of available AI providers and their models"""
    preferences: NotRequired[Nullable[GetPreferencesPreferencesTypedDict]]
    r"""User preferences (null if no preferences exist)"""


class GetPreferencesResponse(BaseModel):
    r"""User preferences and available providers"""

    available_providers: Dict[str, AvailableProviders]
    r"""Map of available AI providers and their models"""

    preferences: OptionalNullable[GetPreferencesPreferences] = UNSET
    r"""User preferences (null if no preferences exist)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["preferences"]
        nullable_fields = ["preferences"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
