"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from mix_python_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SessionDataTypedDict(TypedDict):
    assistant_message_count: int
    r"""Number of assistant messages in session"""
    completion_tokens: int
    r"""Total completion tokens used"""
    cost: float
    r"""Total cost of session"""
    created_at: datetime
    r"""Session creation timestamp"""
    id: str
    r"""Unique session identifier"""
    prompt_tokens: int
    r"""Total prompt tokens used"""
    title: str
    r"""Session title"""
    tool_call_count: int
    r"""Number of tool calls made in session"""
    user_message_count: int
    r"""Number of user messages in session"""
    first_user_message: NotRequired[str]
    r"""First user message (optional)"""
    working_directory: NotRequired[str]
    r"""Working directory path (optional)"""


class SessionData(BaseModel):
    assistant_message_count: Annotated[
        int, pydantic.Field(alias="assistantMessageCount")
    ]
    r"""Number of assistant messages in session"""

    completion_tokens: Annotated[int, pydantic.Field(alias="completionTokens")]
    r"""Total completion tokens used"""

    cost: float
    r"""Total cost of session"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Session creation timestamp"""

    id: str
    r"""Unique session identifier"""

    prompt_tokens: Annotated[int, pydantic.Field(alias="promptTokens")]
    r"""Total prompt tokens used"""

    title: str
    r"""Session title"""

    tool_call_count: Annotated[int, pydantic.Field(alias="toolCallCount")]
    r"""Number of tool calls made in session"""

    user_message_count: Annotated[int, pydantic.Field(alias="userMessageCount")]
    r"""Number of user messages in session"""

    first_user_message: Annotated[
        Optional[str], pydantic.Field(alias="firstUserMessage")
    ] = None
    r"""First user message (optional)"""

    working_directory: Annotated[
        Optional[str], pydantic.Field(alias="workingDirectory")
    ] = None
    r"""Working directory path (optional)"""
