"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class UpdatePreferencesRequestTypedDict(TypedDict):
    main_agent_max_tokens: NotRequired[int]
    r"""Maximum tokens for main agent responses"""
    main_agent_model: NotRequired[str]
    r"""Main agent model ID"""
    main_agent_reasoning_effort: NotRequired[str]
    r"""Reasoning effort setting for main agent"""
    preferred_provider: NotRequired[str]
    r"""Preferred AI provider (anthropic, openai, openrouter)"""
    sub_agent_max_tokens: NotRequired[int]
    r"""Maximum tokens for sub agent responses"""
    sub_agent_model: NotRequired[str]
    r"""Sub agent model ID"""
    sub_agent_reasoning_effort: NotRequired[str]
    r"""Reasoning effort setting for sub agent"""


class UpdatePreferencesRequest(BaseModel):
    main_agent_max_tokens: Optional[int] = None
    r"""Maximum tokens for main agent responses"""

    main_agent_model: Optional[str] = None
    r"""Main agent model ID"""

    main_agent_reasoning_effort: Optional[str] = None
    r"""Reasoning effort setting for main agent"""

    preferred_provider: Optional[str] = None
    r"""Preferred AI provider (anthropic, openai, openrouter)"""

    sub_agent_max_tokens: Optional[int] = None
    r"""Maximum tokens for sub agent responses"""

    sub_agent_model: Optional[str] = None
    r"""Sub agent model ID"""

    sub_agent_reasoning_effort: Optional[str] = None
    r"""Reasoning effort setting for sub agent"""


class UpdatePreferencesResponseTypedDict(TypedDict):
    r"""Updated preferences"""

    created_at: NotRequired[int]
    r"""Creation timestamp"""
    main_agent_max_tokens: NotRequired[int]
    r"""Maximum tokens for main agent"""
    main_agent_model: NotRequired[str]
    r"""Main agent model ID"""
    main_agent_reasoning_effort: NotRequired[str]
    r"""Reasoning effort for main agent"""
    preferred_provider: NotRequired[str]
    r"""Preferred AI provider"""
    sub_agent_max_tokens: NotRequired[int]
    r"""Maximum tokens for sub agent"""
    sub_agent_model: NotRequired[str]
    r"""Sub agent model ID"""
    sub_agent_reasoning_effort: NotRequired[str]
    r"""Reasoning effort for sub agent"""
    updated_at: NotRequired[int]
    r"""Last update timestamp"""


class UpdatePreferencesResponse(BaseModel):
    r"""Updated preferences"""

    created_at: Optional[int] = None
    r"""Creation timestamp"""

    main_agent_max_tokens: Optional[int] = None
    r"""Maximum tokens for main agent"""

    main_agent_model: Optional[str] = None
    r"""Main agent model ID"""

    main_agent_reasoning_effort: Optional[str] = None
    r"""Reasoning effort for main agent"""

    preferred_provider: Optional[str] = None
    r"""Preferred AI provider"""

    sub_agent_max_tokens: Optional[int] = None
    r"""Maximum tokens for sub agent"""

    sub_agent_model: Optional[str] = None
    r"""Sub agent model ID"""

    sub_agent_reasoning_effort: Optional[str] = None
    r"""Reasoning effort for sub agent"""

    updated_at: Optional[int] = None
    r"""Last update timestamp"""
