"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class GetToolsStatusToolTypedDict(TypedDict):
    api_key_required: NotRequired[bool]
    r"""Whether tool requires API key authentication"""
    authenticated: NotRequired[bool]
    r"""Whether tool is authenticated and ready to use"""
    description: NotRequired[str]
    r"""Tool description"""
    display_name: NotRequired[str]
    r"""User-friendly tool name"""
    provider: NotRequired[str]
    r"""Tool provider name"""


class GetToolsStatusTool(BaseModel):
    api_key_required: Optional[bool] = None
    r"""Whether tool requires API key authentication"""

    authenticated: Optional[bool] = None
    r"""Whether tool is authenticated and ready to use"""

    description: Optional[str] = None
    r"""Tool description"""

    display_name: Optional[str] = None
    r"""User-friendly tool name"""

    provider: Optional[str] = None
    r"""Tool provider name"""


class CategoriesTypedDict(TypedDict):
    display_name: NotRequired[str]
    r"""User-friendly category name"""
    tools: NotRequired[List[GetToolsStatusToolTypedDict]]
    r"""Available tools in this category"""


class Categories(BaseModel):
    display_name: Optional[str] = None
    r"""User-friendly category name"""

    tools: Optional[List[GetToolsStatusTool]] = None
    r"""Available tools in this category"""


class GetToolsStatusResponseTypedDict(TypedDict):
    r"""Tools status and authentication information"""

    categories: NotRequired[Dict[str, CategoriesTypedDict]]
    r"""Map of tool categories and their tools"""


class GetToolsStatusResponse(BaseModel):
    r"""Tools status and authentication information"""

    categories: Optional[Dict[str, Categories]] = None
    r"""Map of tool categories and their tools"""
