"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolcalldata import ToolCallData, ToolCallDataTypedDict
from mix_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class BackendMessageTypedDict(TypedDict):
    r"""Backend message structure representing a complete message exchange"""

    id: str
    r"""Unique message identifier"""
    role: str
    r"""Message role (user, assistant, tool)"""
    session_id: str
    r"""Session identifier"""
    user_input: str
    r"""User's input message"""
    assistant_response: NotRequired[str]
    r"""Assistant's response message (optional)"""
    reasoning: NotRequired[str]
    r"""Reasoning process (optional)"""
    reasoning_duration: NotRequired[int]
    r"""Reasoning duration in milliseconds (optional)"""
    tool_calls: NotRequired[List[ToolCallDataTypedDict]]
    r"""Tool calls made during message processing"""


class BackendMessage(BaseModel):
    r"""Backend message structure representing a complete message exchange"""

    id: str
    r"""Unique message identifier"""

    role: str
    r"""Message role (user, assistant, tool)"""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""Session identifier"""

    user_input: Annotated[str, pydantic.Field(alias="userInput")]
    r"""User's input message"""

    assistant_response: Annotated[
        Optional[str], pydantic.Field(alias="assistantResponse")
    ] = None
    r"""Assistant's response message (optional)"""

    reasoning: Optional[str] = None
    r"""Reasoning process (optional)"""

    reasoning_duration: Annotated[
        Optional[int], pydantic.Field(alias="reasoningDuration")
    ] = None
    r"""Reasoning duration in milliseconds (optional)"""

    tool_calls: Annotated[
        Optional[List[ToolCallData]], pydantic.Field(alias="toolCalls")
    ] = None
    r"""Tool calls made during message processing"""
