"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PromptMode = Literal[
    "default",
    "append",
    "replace",
]
r"""Custom prompt handling mode:
- 'default': Use base system prompt only (customSystemPrompt ignored)
- 'append': Append customSystemPrompt to base system prompt (50KB limit)
- 'replace': Replace base system prompt with customSystemPrompt (100KB limit)
"""


class CreateSessionRequestTypedDict(TypedDict):
    title: str
    r"""Title for the session"""
    custom_system_prompt: NotRequired[str]
    r"""Custom system prompt content. Size limits apply based on promptMode: 100KB (102,400 bytes) for replace mode, 50KB (51,200 bytes) for append mode. Ignored in default mode. Supports environment variable substitution with $<variable> syntax."""
    prompt_mode: NotRequired[PromptMode]
    r"""Custom prompt handling mode:
    - 'default': Use base system prompt only (customSystemPrompt ignored)
    - 'append': Append customSystemPrompt to base system prompt (50KB limit)
    - 'replace': Replace base system prompt with customSystemPrompt (100KB limit)
    """


class CreateSessionRequest(BaseModel):
    title: str
    r"""Title for the session"""

    custom_system_prompt: Annotated[
        Optional[str], pydantic.Field(alias="customSystemPrompt")
    ] = None
    r"""Custom system prompt content. Size limits apply based on promptMode: 100KB (102,400 bytes) for replace mode, 50KB (51,200 bytes) for append mode. Ignored in default mode. Supports environment variable substitution with $<variable> syntax."""

    prompt_mode: Annotated[Optional[PromptMode], pydantic.Field(alias="promptMode")] = (
        "default"
    )
    r"""Custom prompt handling mode:
    - 'default': Use base system prompt only (customSystemPrompt ignored)
    - 'append': Append customSystemPrompt to base system prompt (50KB limit)
    - 'replace': Replace base system prompt with customSystemPrompt (100KB limit)
    """
