"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
from mix_python_sdk.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ForkSessionRequestBodyTypedDict(TypedDict):
    message_index: int
    r"""Index of the last message to include in the fork (0-based)"""
    title: NotRequired[str]
    r"""Optional title for the forked session (defaults to 'Forked Session')"""


class ForkSessionRequestBody(BaseModel):
    message_index: Annotated[int, pydantic.Field(alias="messageIndex")]
    r"""Index of the last message to include in the fork (0-based)"""

    title: Optional[str] = None
    r"""Optional title for the forked session (defaults to 'Forked Session')"""


class ForkSessionRequestTypedDict(TypedDict):
    id: str
    r"""Source session ID to fork from"""
    request_body: ForkSessionRequestBodyTypedDict


class ForkSessionRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Source session ID to fork from"""

    request_body: Annotated[
        ForkSessionRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
