"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .toolname import ToolName, ToolNameTypedDict
from mix_python_sdk.types import BaseModel
from mix_python_sdk.utils import get_discriminator
import pydantic
from pydantic import Discriminator, Tag
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


SSESessionDeletedEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSESessionDeletedEventDataTypedDict(TypedDict):
    session_id: str
    r"""ID of the deleted session"""
    type: str
    r"""Event type"""


class SSESessionDeletedEventData(BaseModel):
    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""ID of the deleted session"""

    type: str
    r"""Event type"""


class SSESessionDeletedEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSESessionDeletedEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSESessionDeletedEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSESessionDeletedEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSESessionDeletedEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSESessionDeletedEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSESessionCreatedEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSESessionCreatedEventDataTypedDict(TypedDict):
    created_at: int
    r"""Unix timestamp when the session was created"""
    session_id: str
    r"""ID of the newly created session"""
    title: str
    r"""Title of the newly created session"""
    type: str
    r"""Event type"""


class SSESessionCreatedEventData(BaseModel):
    created_at: Annotated[int, pydantic.Field(alias="createdAt")]
    r"""Unix timestamp when the session was created"""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""ID of the newly created session"""

    title: str
    r"""Title of the newly created session"""

    type: str
    r"""Event type"""


class SSESessionCreatedEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSESessionCreatedEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSESessionCreatedEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSESessionCreatedEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSESessionCreatedEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSESessionCreatedEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSESummarizeEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSESummarizeEventDataTypedDict(TypedDict):
    done: bool
    r"""Indicates if summarization is complete"""
    progress: str
    r"""Summarization progress description"""
    type: str
    r"""Summarization event type"""


class SSESummarizeEventData(BaseModel):
    done: bool
    r"""Indicates if summarization is complete"""

    progress: str
    r"""Summarization progress description"""

    type: str
    r"""Summarization event type"""


class SSESummarizeEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSESummarizeEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSESummarizeEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSESummarizeEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSESummarizeEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSESummarizeEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEPermissionEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class ParamsTypedDict(TypedDict):
    r"""Additional parameters for the permission request"""


class Params(BaseModel):
    r"""Additional parameters for the permission request"""


class SSEPermissionEventDataTypedDict(TypedDict):
    action: str
    r"""Requested action description"""
    description: str
    r"""Human-readable permission description"""
    id: str
    r"""Permission request identifier"""
    session_id: str
    r"""Session identifier for the permission request"""
    tool_name: ToolNameTypedDict
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""
    type: str
    r"""Permission event type"""
    params: NotRequired[ParamsTypedDict]
    r"""Additional parameters for the permission request"""
    path: NotRequired[str]
    r"""File path for permission request"""


class SSEPermissionEventData(BaseModel):
    action: str
    r"""Requested action description"""

    description: str
    r"""Human-readable permission description"""

    id: str
    r"""Permission request identifier"""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""Session identifier for the permission request"""

    tool_name: Annotated[ToolName, pydantic.Field(alias="toolName")]
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""

    type: str
    r"""Permission event type"""

    params: Optional[Params] = None
    r"""Additional parameters for the permission request"""

    path: Optional[str] = None
    r"""File path for permission request"""


class SSEPermissionEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEPermissionEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEPermissionEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEPermissionEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEPermissionEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEPermissionEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEToolExecutionCompleteEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEToolExecutionCompleteEventDataTypedDict(TypedDict):
    progress: str
    r"""Final execution progress description"""
    success: bool
    r"""Indicates if tool execution succeeded"""
    tool_call_id: str
    r"""Tool call identifier"""
    tool_name: ToolNameTypedDict
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""
    type: str
    r"""Tool execution complete event type"""


class SSEToolExecutionCompleteEventData(BaseModel):
    progress: str
    r"""Final execution progress description"""

    success: bool
    r"""Indicates if tool execution succeeded"""

    tool_call_id: Annotated[str, pydantic.Field(alias="toolCallId")]
    r"""Tool call identifier"""

    tool_name: Annotated[ToolName, pydantic.Field(alias="toolName")]
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""

    type: str
    r"""Tool execution complete event type"""


class SSEToolExecutionCompleteEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEToolExecutionCompleteEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEToolExecutionCompleteEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEToolExecutionCompleteEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEToolExecutionCompleteEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEToolExecutionCompleteEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEToolExecutionStartEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEToolExecutionStartEventDataTypedDict(TypedDict):
    progress: str
    r"""Execution progress description"""
    tool_call_id: str
    r"""Tool call identifier"""
    tool_name: ToolNameTypedDict
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""
    type: str
    r"""Tool execution start event type"""


class SSEToolExecutionStartEventData(BaseModel):
    progress: str
    r"""Execution progress description"""

    tool_call_id: Annotated[str, pydantic.Field(alias="toolCallId")]
    r"""Tool call identifier"""

    tool_name: Annotated[ToolName, pydantic.Field(alias="toolName")]
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""

    type: str
    r"""Tool execution start event type"""


class SSEToolExecutionStartEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEToolExecutionStartEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEToolExecutionStartEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEToolExecutionStartEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEToolExecutionStartEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEToolExecutionStartEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEToolEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEToolEventDataTypedDict(TypedDict):
    id: str
    r"""Tool execution identifier"""
    input: str
    r"""Tool input parameters"""
    name: ToolNameTypedDict
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""
    status: str
    r"""Tool execution status"""
    type: str
    r"""Tool event type"""


class SSEToolEventData(BaseModel):
    id: str
    r"""Tool execution identifier"""

    input: str
    r"""Tool input parameters"""

    name: ToolName
    r"""Tool name - either a core tool or MCP tool following {serverName}_{toolName} pattern"""

    status: str
    r"""Tool execution status"""

    type: str
    r"""Tool event type"""


class SSEToolEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEToolEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEToolEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEToolEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEToolEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEToolEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEContentEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEContentEventDataTypedDict(TypedDict):
    content: str
    r"""Streaming content delta"""
    type: str
    r"""Content event type"""


class SSEContentEventData(BaseModel):
    content: str
    r"""Streaming content delta"""

    type: str
    r"""Content event type"""


class SSEContentEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEContentEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEContentEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEContentEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEContentEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEContentEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEThinkingEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEThinkingEventDataTypedDict(TypedDict):
    content: str
    r"""Thinking or reasoning content"""
    type: str
    r"""Thinking event type"""


class SSEThinkingEventData(BaseModel):
    content: str
    r"""Thinking or reasoning content"""

    type: str
    r"""Thinking event type"""


class SSEThinkingEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEThinkingEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEThinkingEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEThinkingEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEThinkingEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEThinkingEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSECompleteEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSECompleteEventDataTypedDict(TypedDict):
    done: bool
    r"""Indicates message processing completion"""
    type: str
    r"""Completion type"""
    content: NotRequired[str]
    r"""Final response content"""
    message_id: NotRequired[str]
    r"""Completed message identifier"""
    reasoning: NotRequired[str]
    r"""Optional reasoning content"""
    reasoning_duration: NotRequired[int]
    r"""Duration of reasoning process in milliseconds"""


class SSECompleteEventData(BaseModel):
    done: bool
    r"""Indicates message processing completion"""

    type: str
    r"""Completion type"""

    content: Optional[str] = None
    r"""Final response content"""

    message_id: Annotated[Optional[str], pydantic.Field(alias="messageId")] = None
    r"""Completed message identifier"""

    reasoning: Optional[str] = None
    r"""Optional reasoning content"""

    reasoning_duration: Annotated[
        Optional[int], pydantic.Field(alias="reasoningDuration")
    ] = None
    r"""Duration of reasoning process in milliseconds"""


class SSECompleteEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSECompleteEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSECompleteEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSECompleteEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSECompleteEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSECompleteEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEErrorEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEErrorEventDataTypedDict(TypedDict):
    error: str
    r"""Error message description"""
    attempt: NotRequired[int]
    r"""Current retry attempt number"""
    max_attempts: NotRequired[int]
    r"""Maximum number of retry attempts"""
    retry_after: NotRequired[int]
    r"""Milliseconds to wait before retry"""
    type: NotRequired[str]
    r"""Error type classification"""


class SSEErrorEventData(BaseModel):
    error: str
    r"""Error message description"""

    attempt: Optional[int] = None
    r"""Current retry attempt number"""

    max_attempts: Annotated[Optional[int], pydantic.Field(alias="maxAttempts")] = None
    r"""Maximum number of retry attempts"""

    retry_after: Annotated[Optional[int], pydantic.Field(alias="retryAfter")] = None
    r"""Milliseconds to wait before retry"""

    type: Optional[str] = None
    r"""Error type classification"""


class SSEErrorEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEErrorEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEErrorEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEErrorEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEErrorEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEErrorEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEHeartbeatEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEHeartbeatEventDataTypedDict(TypedDict):
    type: str
    r"""Heartbeat type"""


class SSEHeartbeatEventData(BaseModel):
    type: str
    r"""Heartbeat type"""


class SSEHeartbeatEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEHeartbeatEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEHeartbeatEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEHeartbeatEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEHeartbeatEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEHeartbeatEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEConnectedEventEvent = Literal[
    "connected",
    "heartbeat",
    "error",
    "complete",
    "thinking",
    "content",
    "tool",
    "tool_execution_start",
    "tool_execution_complete",
    "permission",
    "summarize",
    "session_created",
    "session_deleted",
]
r"""Event type identifier"""


class SSEConnectedEventDataTypedDict(TypedDict):
    session_id: str
    r"""Session identifier for the connected stream"""


class SSEConnectedEventData(BaseModel):
    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""Session identifier for the connected stream"""


class SSEConnectedEventTypedDict(TypedDict):
    r"""Base SSE event with standard fields"""

    event: SSEConnectedEventEvent
    r"""Event type identifier"""
    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""
    data: SSEConnectedEventDataTypedDict
    retry: NotRequired[int]
    r"""Client retry interval in milliseconds"""


class SSEConnectedEvent(BaseModel):
    r"""Base SSE event with standard fields"""

    event: SSEConnectedEventEvent
    r"""Event type identifier"""

    id: str
    r"""Unique sequential event identifier for ordering and reconnection"""

    data: SSEConnectedEventData

    retry: Optional[int] = None
    r"""Client retry interval in milliseconds"""


SSEEventStreamTypedDict = TypeAliasType(
    "SSEEventStreamTypedDict",
    Union[
        SSEConnectedEventTypedDict,
        SSEHeartbeatEventTypedDict,
        SSEErrorEventTypedDict,
        SSECompleteEventTypedDict,
        SSEThinkingEventTypedDict,
        SSEContentEventTypedDict,
        SSEToolEventTypedDict,
        SSEToolExecutionStartEventTypedDict,
        SSEToolExecutionCompleteEventTypedDict,
        SSEPermissionEventTypedDict,
        SSESummarizeEventTypedDict,
        SSESessionCreatedEventTypedDict,
        SSESessionDeletedEventTypedDict,
    ],
)
r"""Server-Sent Event stream with discriminated event types"""


SSEEventStream = Annotated[
    Union[
        Annotated[SSECompleteEvent, Tag("complete")],
        Annotated[SSEConnectedEvent, Tag("connected")],
        Annotated[SSEContentEvent, Tag("content")],
        Annotated[SSEErrorEvent, Tag("error")],
        Annotated[SSEHeartbeatEvent, Tag("heartbeat")],
        Annotated[SSEPermissionEvent, Tag("permission")],
        Annotated[SSESessionCreatedEvent, Tag("session_created")],
        Annotated[SSESessionDeletedEvent, Tag("session_deleted")],
        Annotated[SSESummarizeEvent, Tag("summarize")],
        Annotated[SSEThinkingEvent, Tag("thinking")],
        Annotated[SSEToolEvent, Tag("tool")],
        Annotated[SSEToolExecutionCompleteEvent, Tag("tool_execution_complete")],
        Annotated[SSEToolExecutionStartEvent, Tag("tool_execution_start")],
    ],
    Discriminator(lambda m: get_discriminator(m, "event", "event")),
]
r"""Server-Sent Event stream with discriminated event types"""
