"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import io
from mix_python_sdk.types import BaseModel
from mix_python_sdk.utils import (
    FieldMetadata,
    MultipartFormMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class FileTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class File(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class UploadSessionFileRequestBodyTypedDict(TypedDict):
    file: FileTypedDict
    r"""File to upload"""


class UploadSessionFileRequestBody(BaseModel):
    file: Annotated[File, FieldMetadata(multipart=MultipartFormMetadata(file=True))]
    r"""File to upload"""


class UploadSessionFileRequestTypedDict(TypedDict):
    id: str
    r"""Session ID"""
    request_body: UploadSessionFileRequestBodyTypedDict


class UploadSessionFileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Session ID"""

    request_body: Annotated[
        UploadSessionFileRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="multipart/form-data")),
    ]
