"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .exportmessage import ExportMessage, ExportMessageTypedDict
from datetime import datetime
from mix_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ExportSessionTypedDict(TypedDict):
    r"""Comprehensive session export with all messages, tool calls, and metadata"""

    id: str
    r"""Session identifier"""
    messages: List[ExportMessageTypedDict]
    r"""Complete list of messages with full details"""
    title: str
    r"""Session title"""
    assistant_message_count: NotRequired[int]
    r"""Number of assistant messages"""
    completion_tokens: NotRequired[int]
    r"""Total completion tokens used"""
    cost: NotRequired[float]
    r"""Total cost of session"""
    created_at: NotRequired[datetime]
    r"""Session creation timestamp"""
    prompt_tokens: NotRequired[int]
    r"""Total prompt tokens used"""
    tool_call_count: NotRequired[int]
    r"""Total number of tool calls"""
    updated_at: NotRequired[datetime]
    r"""Session last update timestamp"""
    user_message_count: NotRequired[int]
    r"""Number of user messages"""


class ExportSession(BaseModel):
    r"""Comprehensive session export with all messages, tool calls, and metadata"""

    id: str
    r"""Session identifier"""

    messages: List[ExportMessage]
    r"""Complete list of messages with full details"""

    title: str
    r"""Session title"""

    assistant_message_count: Annotated[
        Optional[int], pydantic.Field(alias="assistantMessageCount")
    ] = None
    r"""Number of assistant messages"""

    completion_tokens: Annotated[
        Optional[int], pydantic.Field(alias="completionTokens")
    ] = None
    r"""Total completion tokens used"""

    cost: Optional[float] = None
    r"""Total cost of session"""

    created_at: Annotated[Optional[datetime], pydantic.Field(alias="createdAt")] = None
    r"""Session creation timestamp"""

    prompt_tokens: Annotated[Optional[int], pydantic.Field(alias="promptTokens")] = None
    r"""Total prompt tokens used"""

    tool_call_count: Annotated[Optional[int], pydantic.Field(alias="toolCallCount")] = (
        None
    )
    r"""Total number of tool calls"""

    updated_at: Annotated[Optional[datetime], pydantic.Field(alias="updatedAt")] = None
    r"""Session last update timestamp"""

    user_message_count: Annotated[
        Optional[int], pydantic.Field(alias="userMessageCount")
    ] = None
    r"""Number of user messages"""
