"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
import pydantic
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


CallbackType = Literal[
    "bash_script",
    "sub_agent",
    "send_message",
]
r"""Callback type: 'bash_script' for shell commands, 'sub_agent' for spawning sub-agents, 'send_message' for injecting messages"""


class CallbackTypedDict(TypedDict):
    r"""Session-level callback configuration that executes after tool completion"""

    tool_name: str
    r"""Tool to attach callback to (e.g., 'show_media', 'bash', '*' for all tools)"""
    type: CallbackType
    r"""Callback type: 'bash_script' for shell commands, 'sub_agent' for spawning sub-agents, 'send_message' for injecting messages"""
    bash_command: NotRequired[str]
    r"""Bash command to execute (required for bash_script type). Has access to environment variables."""
    bash_timeout: NotRequired[int]
    r"""Timeout in milliseconds for bash execution (default: 120000)"""
    exclude_from_context: NotRequired[bool]
    r"""Exclude callback results from agent context. Only applies to bash_script and sub_agent types. Not allowed for send_message."""
    include_full_history: NotRequired[bool]
    r"""Include full conversation history in sub-agent context (not yet implemented)"""
    message_content: NotRequired[str]
    r"""Message content to inject into the conversation (required for send_message type). Will be sent as a User message."""
    name: NotRequired[str]
    r"""Human-readable name for this callback (optional, defaults to 'Callback #XXXX')"""
    sub_agent_prompt: NotRequired[str]
    r"""Prompt for the sub-agent (required for sub_agent type). Tool execution context is automatically appended."""
    sub_agent_type: NotRequired[str]
    r"""Type of sub-agent to spawn (default: 'general-purpose')"""


class Callback(BaseModel):
    r"""Session-level callback configuration that executes after tool completion"""

    tool_name: Annotated[str, pydantic.Field(alias="toolName")]
    r"""Tool to attach callback to (e.g., 'show_media', 'bash', '*' for all tools)"""

    type: CallbackType
    r"""Callback type: 'bash_script' for shell commands, 'sub_agent' for spawning sub-agents, 'send_message' for injecting messages"""

    bash_command: Annotated[Optional[str], pydantic.Field(alias="bashCommand")] = None
    r"""Bash command to execute (required for bash_script type). Has access to environment variables."""

    bash_timeout: Annotated[Optional[int], pydantic.Field(alias="bashTimeout")] = 120000
    r"""Timeout in milliseconds for bash execution (default: 120000)"""

    exclude_from_context: Annotated[
        Optional[bool], pydantic.Field(alias="excludeFromContext")
    ] = False
    r"""Exclude callback results from agent context. Only applies to bash_script and sub_agent types. Not allowed for send_message."""

    include_full_history: Annotated[
        Optional[bool], pydantic.Field(alias="includeFullHistory")
    ] = False
    r"""Include full conversation history in sub-agent context (not yet implemented)"""

    message_content: Annotated[
        Optional[str], pydantic.Field(alias="messageContent")
    ] = None
    r"""Message content to inject into the conversation (required for send_message type). Will be sent as a User message."""

    name: Optional[str] = None
    r"""Human-readable name for this callback (optional, defaults to 'Callback #XXXX')"""

    sub_agent_prompt: Annotated[
        Optional[str], pydantic.Field(alias="subAgentPrompt")
    ] = None
    r"""Prompt for the sub-agent (required for sub_agent type). Tool execution context is automatically appended."""

    sub_agent_type: Annotated[Optional[str], pydantic.Field(alias="subAgentType")] = (
        "general-purpose"
    )
    r"""Type of sub-agent to spawn (default: 'general-purpose')"""
