"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .exporttoolcall import ExportToolCall, ExportToolCallTypedDict
from datetime import datetime
from mix_python_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ExportMessageTypedDict(TypedDict):
    r"""Complete message information for export"""

    content: str
    r"""Message content"""
    created_at: datetime
    r"""Message creation timestamp"""
    id: str
    r"""Message identifier"""
    role: str
    r"""Message role (user, assistant, tool)"""
    updated_at: datetime
    r"""Message update timestamp"""
    finish_reason: NotRequired[str]
    r"""Completion finish reason (optional)"""
    model: NotRequired[str]
    r"""Model used for this message (optional)"""
    reasoning: NotRequired[str]
    r"""Reasoning content (optional)"""
    reasoning_duration: NotRequired[int]
    r"""Reasoning duration in milliseconds (optional)"""
    tool_calls: NotRequired[List[ExportToolCallTypedDict]]
    r"""Tool calls with complete information"""


class ExportMessage(BaseModel):
    r"""Complete message information for export"""

    content: str
    r"""Message content"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Message creation timestamp"""

    id: str
    r"""Message identifier"""

    role: str
    r"""Message role (user, assistant, tool)"""

    updated_at: Annotated[datetime, pydantic.Field(alias="updatedAt")]
    r"""Message update timestamp"""

    finish_reason: Annotated[Optional[str], pydantic.Field(alias="finishReason")] = None
    r"""Completion finish reason (optional)"""

    model: Optional[str] = None
    r"""Model used for this message (optional)"""

    reasoning: Optional[str] = None
    r"""Reasoning content (optional)"""

    reasoning_duration: Annotated[
        Optional[int], pydantic.Field(alias="reasoningDuration")
    ] = None
    r"""Reasoning duration in milliseconds (optional)"""

    tool_calls: Annotated[
        Optional[List[ExportToolCall]], pydantic.Field(alias="toolCalls")
    ] = None
    r"""Tool calls with complete information"""
