"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class InputJSONTypedDict(TypedDict):
    r"""Parsed tool input (optional)"""


class InputJSON(BaseModel):
    r"""Parsed tool input (optional)"""


class ExportToolCallTypedDict(TypedDict):
    r"""Complete tool call information for export"""

    finished: bool
    r"""Whether tool execution finished"""
    id: str
    r"""Tool call identifier"""
    input: str
    r"""Tool input as JSON string"""
    name: str
    r"""Tool name"""
    type: str
    r"""Tool type"""
    input_json: NotRequired[InputJSONTypedDict]
    r"""Parsed tool input (optional)"""
    is_error: NotRequired[bool]
    r"""Whether execution resulted in error (optional)"""
    metadata: NotRequired[str]
    r"""Additional tool metadata (optional)"""
    result: NotRequired[str]
    r"""Tool execution result (optional)"""


class ExportToolCall(BaseModel):
    r"""Complete tool call information for export"""

    finished: bool
    r"""Whether tool execution finished"""

    id: str
    r"""Tool call identifier"""

    input: str
    r"""Tool input as JSON string"""

    name: str
    r"""Tool name"""

    type: str
    r"""Tool type"""

    input_json: Annotated[Optional[InputJSON], pydantic.Field(alias="inputJson")] = None
    r"""Parsed tool input (optional)"""

    is_error: Annotated[Optional[bool], pydantic.Field(alias="isError")] = None
    r"""Whether execution resulted in error (optional)"""

    metadata: Optional[str] = None
    r"""Additional tool metadata (optional)"""

    result: Optional[str] = None
    r"""Tool execution result (optional)"""
