"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from mix_python_sdk.types import BaseModel
from typing import Dict, Literal, Optional
from typing_extensions import NotRequired, TypedDict


ProvidersStatus = Literal[
    "active",
    "expired",
    "expired_no_refresh",
    "error",
    "not_found",
]
r"""Token status"""


class GetOAuthHealthProvidersTypedDict(TypedDict):
    provider: str
    r"""Provider name"""
    status: ProvidersStatus
    r"""Token status"""
    error: NotRequired[str]
    r"""Error message if status is 'error'"""
    expires_at: NotRequired[datetime]
    r"""Token expiration time"""
    expires_in: NotRequired[str]
    r"""Human-readable time until expiration"""
    last_refresh: NotRequired[datetime]
    r"""Last time token was refreshed"""


class GetOAuthHealthProviders(BaseModel):
    provider: str
    r"""Provider name"""

    status: ProvidersStatus
    r"""Token status"""

    error: Optional[str] = None
    r"""Error message if status is 'error'"""

    expires_at: Optional[datetime] = None
    r"""Token expiration time"""

    expires_in: Optional[str] = None
    r"""Human-readable time until expiration"""

    last_refresh: Optional[datetime] = None
    r"""Last time token was refreshed"""


Status = Literal[
    "healthy",
    "degraded",
    "unhealthy",
]
r"""Overall health status"""


class GetOAuthHealthResponseTypedDict(TypedDict):
    r"""OAuth health status"""

    providers: Dict[str, GetOAuthHealthProvidersTypedDict]
    r"""Map of provider OAuth health status"""
    status: Status
    r"""Overall health status"""
    timestamp: datetime
    r"""Health check timestamp"""


class GetOAuthHealthResponse(BaseModel):
    r"""OAuth health status"""

    providers: Dict[str, GetOAuthHealthProviders]
    r"""Map of provider OAuth health status"""

    status: Status
    r"""Overall health status"""

    timestamp: datetime
    r"""Health check timestamp"""
