"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .callback import Callback, CallbackTypedDict
from datetime import datetime
from mix_python_sdk.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


SessionType = Literal[
    "main",
    "forked",
    "subagent",
]
r"""Session type:
- 'main': Root-level user interactions
- 'forked': User-created conversation branches
- 'subagent': Delegated task workers
"""


SubagentType = Literal["general-purpose",]
r"""Subagent specialization type (only present for subagent sessions)"""


class SessionDataTypedDict(TypedDict):
    assistant_message_count: int
    r"""Number of assistant messages in session"""
    completion_tokens: int
    r"""Total completion tokens used"""
    cost: float
    r"""Total cost of session (for subagent sessions, costs are also accumulated in parent session)"""
    created_at: datetime
    r"""Session creation timestamp"""
    id: str
    r"""Unique session identifier"""
    prompt_tokens: int
    r"""Total prompt tokens used"""
    session_type: SessionType
    r"""Session type:
    - 'main': Root-level user interactions
    - 'forked': User-created conversation branches
    - 'subagent': Delegated task workers
    """
    title: str
    r"""Session title"""
    tool_call_count: int
    r"""Number of tool calls made in session"""
    user_message_count: int
    r"""Number of user messages in session"""
    callbacks: NotRequired[List[CallbackTypedDict]]
    r"""Session-level callback configurations (optional)"""
    first_user_message: NotRequired[str]
    r"""First user message (optional)"""
    parent_session_id: NotRequired[str]
    r"""Parent session ID for forked and subagent sessions (null for main sessions)"""
    parent_tool_call_id: NotRequired[str]
    r"""ID of the tool call that spawned this subagent session (null for non-subagent sessions)"""
    subagent_type: NotRequired[SubagentType]
    r"""Subagent specialization type (only present for subagent sessions)"""


class SessionData(BaseModel):
    assistant_message_count: Annotated[
        int, pydantic.Field(alias="assistantMessageCount")
    ]
    r"""Number of assistant messages in session"""

    completion_tokens: Annotated[int, pydantic.Field(alias="completionTokens")]
    r"""Total completion tokens used"""

    cost: float
    r"""Total cost of session (for subagent sessions, costs are also accumulated in parent session)"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Session creation timestamp"""

    id: str
    r"""Unique session identifier"""

    prompt_tokens: Annotated[int, pydantic.Field(alias="promptTokens")]
    r"""Total prompt tokens used"""

    session_type: Annotated[SessionType, pydantic.Field(alias="sessionType")]
    r"""Session type:
    - 'main': Root-level user interactions
    - 'forked': User-created conversation branches
    - 'subagent': Delegated task workers
    """

    title: str
    r"""Session title"""

    tool_call_count: Annotated[int, pydantic.Field(alias="toolCallCount")]
    r"""Number of tool calls made in session"""

    user_message_count: Annotated[int, pydantic.Field(alias="userMessageCount")]
    r"""Number of user messages in session"""

    callbacks: Optional[List[Callback]] = None
    r"""Session-level callback configurations (optional)"""

    first_user_message: Annotated[
        Optional[str], pydantic.Field(alias="firstUserMessage")
    ] = None
    r"""First user message (optional)"""

    parent_session_id: Annotated[
        Optional[str], pydantic.Field(alias="parentSessionId")
    ] = None
    r"""Parent session ID for forked and subagent sessions (null for main sessions)"""

    parent_tool_call_id: Annotated[
        Optional[str], pydantic.Field(alias="parentToolCallId")
    ] = None
    r"""ID of the tool call that spawned this subagent session (null for non-subagent sessions)"""

    subagent_type: Annotated[
        Optional[SubagentType], pydantic.Field(alias="subagentType")
    ] = None
    r"""Subagent specialization type (only present for subagent sessions)"""
