"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sseeventstream import SSEEventStream, SSEEventStreamTypedDict
from mix_python_sdk.types import BaseModel
from mix_python_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    QueryParamMetadata,
    eventstreaming,
)
import pydantic
from pydantic import SkipValidation
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class StreamEventsRequestTypedDict(TypedDict):
    session_id: str
    r"""Session ID to stream events for"""
    last_event_id: NotRequired[str]
    r"""Last received event ID for reconnection and event replay"""


class StreamEventsRequest(BaseModel):
    session_id: Annotated[
        str,
        pydantic.Field(alias="sessionId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""Session ID to stream events for"""

    last_event_id: Annotated[
        Optional[str],
        pydantic.Field(alias="Last-Event-ID"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Last received event ID for reconnection and event replay"""


class StreamEventsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: Union[
        eventstreaming.EventStream[SSEEventStreamTypedDict],
        eventstreaming.EventStreamAsync[SSEEventStreamTypedDict],
    ]


class StreamEventsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: SkipValidation[
        Union[
            eventstreaming.EventStream[SSEEventStream],
            eventstreaming.EventStreamAsync[SSEEventStream],
        ]
    ]
