"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
from typing import Literal, Optional
from typing_extensions import NotRequired, TypedDict


CallbackResultDataCallbackType = Literal[
    "bash_script",
    "sub_agent",
    "send_message",
]
r"""Type of callback executed"""


class CallbackResultDataTypedDict(TypedDict):
    r"""Callback execution result information"""

    callback_type: CallbackResultDataCallbackType
    r"""Type of callback executed"""
    success: bool
    r"""Whether callback executed successfully"""
    tool_call_id: str
    r"""ID of the tool call that triggered this callback"""
    tool_name: str
    r"""Name of the tool that triggered callback"""
    callback_name: NotRequired[str]
    r"""Human-readable name of the callback (optional)"""
    error: NotRequired[str]
    r"""Error message if callback failed (optional)"""
    exclude_from_context: NotRequired[bool]
    r"""Whether this callback result is excluded from agent context (optional)"""
    exit_code: NotRequired[int]
    r"""Exit code from bash callback (optional)"""
    stderr: NotRequired[str]
    r"""Standard error from bash callback (optional)"""
    stdout: NotRequired[str]
    r"""Standard output from bash callback (optional)"""
    subagent_id: NotRequired[str]
    r"""ID of spawned sub-agent session (optional)"""
    subagent_result: NotRequired[str]
    r"""Result from sub-agent execution (optional)"""


class CallbackResultData(BaseModel):
    r"""Callback execution result information"""

    callback_type: CallbackResultDataCallbackType
    r"""Type of callback executed"""

    success: bool
    r"""Whether callback executed successfully"""

    tool_call_id: str
    r"""ID of the tool call that triggered this callback"""

    tool_name: str
    r"""Name of the tool that triggered callback"""

    callback_name: Optional[str] = None
    r"""Human-readable name of the callback (optional)"""

    error: Optional[str] = None
    r"""Error message if callback failed (optional)"""

    exclude_from_context: Optional[bool] = None
    r"""Whether this callback result is excluded from agent context (optional)"""

    exit_code: Optional[int] = None
    r"""Exit code from bash callback (optional)"""

    stderr: Optional[str] = None
    r"""Standard error from bash callback (optional)"""

    stdout: Optional[str] = None
    r"""Standard output from bash callback (optional)"""

    subagent_id: Optional[str] = None
    r"""ID of spawned sub-agent session (optional)"""

    subagent_result: Optional[str] = None
    r"""Result from sub-agent execution (optional)"""
