"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
from mix_python_sdk.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SendMessageRequestBodyTypedDict(TypedDict):
    text: str
    r"""The text content of the message"""
    plan_mode: NotRequired[bool]
    r"""Whether the message is in planning mode"""


class SendMessageRequestBody(BaseModel):
    text: str
    r"""The text content of the message"""

    plan_mode: Optional[bool] = False
    r"""Whether the message is in planning mode"""


class SendMessageRequestTypedDict(TypedDict):
    id: str
    r"""Session ID"""
    request_body: SendMessageRequestBodyTypedDict


class SendMessageRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Session ID"""

    request_body: Annotated[
        SendMessageRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class SendMessageResponseTypedDict(TypedDict):
    r"""Message accepted for processing. Agent runs asynchronously and streams results via SSE."""

    session_id: str
    r"""Session ID for the processing task"""
    status: str
    r"""Processing status"""


class SendMessageResponse(BaseModel):
    r"""Message accepted for processing. Agent runs asynchronously and streams results via SSE."""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""Session ID for the processing task"""

    status: str
    r"""Processing status"""
