"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .callback import Callback, CallbackTypedDict
from mix_python_sdk.types import BaseModel
import pydantic
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


PromptMode = Literal[
    "default",
    "append",
    "replace",
]
r"""Custom prompt handling mode:
- 'default': Use base system prompt only (customSystemPrompt ignored)
- 'append': Append customSystemPrompt to base system prompt (50KB limit)
- 'replace': Replace base system prompt with customSystemPrompt (100KB limit)
"""


CreateSessionSessionType = Literal["main",]
r"""Session type. API can only create 'main' sessions. Forked sessions are created via /fork endpoint. Subagent sessions are created automatically by the task delegation system."""


class CreateSessionRequestTypedDict(TypedDict):
    title: str
    r"""Title for the session"""
    callbacks: NotRequired[List[CallbackTypedDict]]
    r"""Session-level callbacks that execute after tool completion. Environment variables available: CALLBACK_TOOL_RESULT, CALLBACK_TOOL_NAME, CALLBACK_TOOL_ID, CALLBACK_SESSION_ID"""
    custom_system_prompt: NotRequired[str]
    r"""Custom system prompt content. Size limits apply based on promptMode: 100KB (102,400 bytes) for replace mode, 50KB (51,200 bytes) for append mode. Ignored in default mode. Supports environment variable substitution with $<variable> syntax."""
    prompt_mode: NotRequired[PromptMode]
    r"""Custom prompt handling mode:
    - 'default': Use base system prompt only (customSystemPrompt ignored)
    - 'append': Append customSystemPrompt to base system prompt (50KB limit)
    - 'replace': Replace base system prompt with customSystemPrompt (100KB limit)
    """
    session_type: NotRequired[CreateSessionSessionType]
    r"""Session type. API can only create 'main' sessions. Forked sessions are created via /fork endpoint. Subagent sessions are created automatically by the task delegation system."""
    subagent_type: NotRequired[str]
    r"""Subagent type - must not be set for API-created sessions. This field is reserved for programmatic subagent creation."""


class CreateSessionRequest(BaseModel):
    title: str
    r"""Title for the session"""

    callbacks: Optional[List[Callback]] = None
    r"""Session-level callbacks that execute after tool completion. Environment variables available: CALLBACK_TOOL_RESULT, CALLBACK_TOOL_NAME, CALLBACK_TOOL_ID, CALLBACK_SESSION_ID"""

    custom_system_prompt: Annotated[
        Optional[str], pydantic.Field(alias="customSystemPrompt")
    ] = None
    r"""Custom system prompt content. Size limits apply based on promptMode: 100KB (102,400 bytes) for replace mode, 50KB (51,200 bytes) for append mode. Ignored in default mode. Supports environment variable substitution with $<variable> syntax."""

    prompt_mode: Annotated[Optional[PromptMode], pydantic.Field(alias="promptMode")] = (
        "default"
    )
    r"""Custom prompt handling mode:
    - 'default': Use base system prompt only (customSystemPrompt ignored)
    - 'append': Append customSystemPrompt to base system prompt (50KB limit)
    - 'replace': Replace base system prompt with customSystemPrompt (100KB limit)
    """

    session_type: Annotated[
        Optional[CreateSessionSessionType], pydantic.Field(alias="sessionType")
    ] = "main"
    r"""Session type. API can only create 'main' sessions. Forked sessions are created via /fork endpoint. Subagent sessions are created automatically by the task delegation system."""

    subagent_type: Annotated[Optional[str], pydantic.Field(alias="subagentType")] = None
    r"""Subagent type - must not be set for API-created sessions. This field is reserved for programmatic subagent creation."""
