"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import BaseModel
from mix_python_sdk.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RewindSessionRequestBodyTypedDict(TypedDict):
    message_id: str
    r"""ID of the last message to keep. All messages after this message will be deleted."""
    cleanup_media: NotRequired[bool]
    r"""Whether to clean up media files created after the rewind point (based on file timestamp)"""


class RewindSessionRequestBody(BaseModel):
    message_id: Annotated[str, pydantic.Field(alias="messageId")]
    r"""ID of the last message to keep. All messages after this message will be deleted."""

    cleanup_media: Annotated[Optional[bool], pydantic.Field(alias="cleanupMedia")] = (
        True
    )
    r"""Whether to clean up media files created after the rewind point (based on file timestamp)"""


class RewindSessionRequestTypedDict(TypedDict):
    id: str
    r"""Session ID to rewind"""
    request_body: RewindSessionRequestBodyTypedDict


class RewindSessionRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Session ID to rewind"""

    request_body: Annotated[
        RewindSessionRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
