"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mix_python_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mix_python_sdk.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


ThinkingLevel = Literal[
    "off",
    "basic",
    "medium",
    "maximum",
]
r"""Thinking level: off (disabled), basic (4k tokens), medium (10k tokens), maximum (32k tokens). If not provided, determined by keywords in message."""


class SendMessageRequestBodyTypedDict(TypedDict):
    text: str
    r"""The text content of the message"""
    plan_mode: NotRequired[bool]
    r"""Whether the message is in planning mode"""
    thinking_level: NotRequired[Nullable[ThinkingLevel]]
    r"""Thinking level: off (disabled), basic (4k tokens), medium (10k tokens), maximum (32k tokens). If not provided, determined by keywords in message."""


class SendMessageRequestBody(BaseModel):
    text: str
    r"""The text content of the message"""

    plan_mode: Optional[bool] = False
    r"""Whether the message is in planning mode"""

    thinking_level: OptionalNullable[ThinkingLevel] = UNSET
    r"""Thinking level: off (disabled), basic (4k tokens), medium (10k tokens), maximum (32k tokens). If not provided, determined by keywords in message."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["plan_mode", "thinking_level"]
        nullable_fields = ["thinking_level"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SendMessageRequestTypedDict(TypedDict):
    id: str
    r"""Session ID"""
    request_body: SendMessageRequestBodyTypedDict


class SendMessageRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Session ID"""

    request_body: Annotated[
        SendMessageRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class SendMessageResponseTypedDict(TypedDict):
    r"""Message accepted for processing. Agent runs asynchronously and streams results via SSE."""

    session_id: str
    r"""Session ID for the processing task"""
    status: str
    r"""Processing status"""


class SendMessageResponse(BaseModel):
    r"""Message accepted for processing. Agent runs asynchronously and streams results via SSE."""

    session_id: Annotated[str, pydantic.Field(alias="sessionId")]
    r"""Session ID for the processing task"""

    status: str
    r"""Processing status"""
