from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.job_spec_master_strategy import JobSpecMasterStrategy
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.job_spec_env import JobSpecEnv


T = TypeVar("T", bound="JobSpec")


@_attrs_define
class JobSpec:
    """Domain-specific job specification (rendered into slurm script)

    Attributes:
        artifact_dir (Union[Unset, str]): Artifacts directory
        cpus_per_task (Union[Unset, int]): CPUs per task
        env (Union[Unset, JobSpecEnv]): Environment variables
        gpus_per_node (Union[Unset, int]): GPUs per node
        log_dir (Union[Unset, str]): Logs directory
        master_strategy (Union[Unset, JobSpecMasterStrategy]): Strategy for master node selection Default:
            JobSpecMasterStrategy.FIRST_NODE.
        mem (Union[Unset, str]): Memory requirement (e.g., "8G")
        mounts (Union[Unset, list[str]]): Container mounts (e.g., ["/path1:/path1"])
        nodes (Union[Unset, int]): Number of nodes
        num_tool_workers (Union[Unset, int]): Number of tool workers
        num_train_workers (Union[Unset, int]): Number of training workers
        partition (Union[Unset, str]): Partition name
        proxy_image (Union[Unset, str]): Proxy container image
        qos (Union[Unset, str]): Quality of Service
        run_dir (Union[Unset, str]): Run directory
        time (Union[Unset, str]): Time limit
        tool_image (Union[Unset, str]): Tooling container image
        tool_master_cmd (Union[Unset, str]): Tooling master command
        tool_worker_cmd (Union[Unset, str]): Tooling worker command
        train_image (Union[Unset, str]): Training container image
        train_master_cmd (Union[Unset, str]): Training master command
        train_worker_cmd (Union[Unset, str]): Training worker command
    """

    artifact_dir: Union[Unset, str] = UNSET
    cpus_per_task: Union[Unset, int] = UNSET
    env: Union[Unset, "JobSpecEnv"] = UNSET
    gpus_per_node: Union[Unset, int] = UNSET
    log_dir: Union[Unset, str] = UNSET
    master_strategy: Union[Unset, JobSpecMasterStrategy] = JobSpecMasterStrategy.FIRST_NODE
    mem: Union[Unset, str] = UNSET
    mounts: Union[Unset, list[str]] = UNSET
    nodes: Union[Unset, int] = UNSET
    num_tool_workers: Union[Unset, int] = UNSET
    num_train_workers: Union[Unset, int] = UNSET
    partition: Union[Unset, str] = UNSET
    proxy_image: Union[Unset, str] = UNSET
    qos: Union[Unset, str] = UNSET
    run_dir: Union[Unset, str] = UNSET
    time: Union[Unset, str] = UNSET
    tool_image: Union[Unset, str] = UNSET
    tool_master_cmd: Union[Unset, str] = UNSET
    tool_worker_cmd: Union[Unset, str] = UNSET
    train_image: Union[Unset, str] = UNSET
    train_master_cmd: Union[Unset, str] = UNSET
    train_worker_cmd: Union[Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        artifact_dir = self.artifact_dir

        cpus_per_task = self.cpus_per_task

        env: Union[Unset, dict[str, Any]] = UNSET
        if not isinstance(self.env, Unset):
            env = self.env.to_dict()

        gpus_per_node = self.gpus_per_node

        log_dir = self.log_dir

        master_strategy: Union[Unset, str] = UNSET
        if not isinstance(self.master_strategy, Unset):
            master_strategy = self.master_strategy.value

        mem = self.mem

        mounts: Union[Unset, list[str]] = UNSET
        if not isinstance(self.mounts, Unset):
            mounts = self.mounts

        nodes = self.nodes

        num_tool_workers = self.num_tool_workers

        num_train_workers = self.num_train_workers

        partition = self.partition

        proxy_image = self.proxy_image

        qos = self.qos

        run_dir = self.run_dir

        time = self.time

        tool_image = self.tool_image

        tool_master_cmd = self.tool_master_cmd

        tool_worker_cmd = self.tool_worker_cmd

        train_image = self.train_image

        train_master_cmd = self.train_master_cmd

        train_worker_cmd = self.train_worker_cmd

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if artifact_dir is not UNSET:
            field_dict["artifact_dir"] = artifact_dir
        if cpus_per_task is not UNSET:
            field_dict["cpus_per_task"] = cpus_per_task
        if env is not UNSET:
            field_dict["env"] = env
        if gpus_per_node is not UNSET:
            field_dict["gpus_per_node"] = gpus_per_node
        if log_dir is not UNSET:
            field_dict["log_dir"] = log_dir
        if master_strategy is not UNSET:
            field_dict["master_strategy"] = master_strategy
        if mem is not UNSET:
            field_dict["mem"] = mem
        if mounts is not UNSET:
            field_dict["mounts"] = mounts
        if nodes is not UNSET:
            field_dict["nodes"] = nodes
        if num_tool_workers is not UNSET:
            field_dict["num_tool_workers"] = num_tool_workers
        if num_train_workers is not UNSET:
            field_dict["num_train_workers"] = num_train_workers
        if partition is not UNSET:
            field_dict["partition"] = partition
        if proxy_image is not UNSET:
            field_dict["proxy_image"] = proxy_image
        if qos is not UNSET:
            field_dict["qos"] = qos
        if run_dir is not UNSET:
            field_dict["run_dir"] = run_dir
        if time is not UNSET:
            field_dict["time"] = time
        if tool_image is not UNSET:
            field_dict["tool_image"] = tool_image
        if tool_master_cmd is not UNSET:
            field_dict["tool_master_cmd"] = tool_master_cmd
        if tool_worker_cmd is not UNSET:
            field_dict["tool_worker_cmd"] = tool_worker_cmd
        if train_image is not UNSET:
            field_dict["train_image"] = train_image
        if train_master_cmd is not UNSET:
            field_dict["train_master_cmd"] = train_master_cmd
        if train_worker_cmd is not UNSET:
            field_dict["train_worker_cmd"] = train_worker_cmd

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.job_spec_env import JobSpecEnv

        d = dict(src_dict)
        artifact_dir = d.pop("artifact_dir", UNSET)

        cpus_per_task = d.pop("cpus_per_task", UNSET)

        _env = d.pop("env", UNSET)
        env: Union[Unset, JobSpecEnv]
        if isinstance(_env, Unset):
            env = UNSET
        else:
            env = JobSpecEnv.from_dict(_env)

        gpus_per_node = d.pop("gpus_per_node", UNSET)

        log_dir = d.pop("log_dir", UNSET)

        _master_strategy = d.pop("master_strategy", UNSET)
        master_strategy: Union[Unset, JobSpecMasterStrategy]
        if isinstance(_master_strategy, Unset):
            master_strategy = UNSET
        else:
            master_strategy = JobSpecMasterStrategy(_master_strategy)

        mem = d.pop("mem", UNSET)

        mounts = cast(list[str], d.pop("mounts", UNSET))

        nodes = d.pop("nodes", UNSET)

        num_tool_workers = d.pop("num_tool_workers", UNSET)

        num_train_workers = d.pop("num_train_workers", UNSET)

        partition = d.pop("partition", UNSET)

        proxy_image = d.pop("proxy_image", UNSET)

        qos = d.pop("qos", UNSET)

        run_dir = d.pop("run_dir", UNSET)

        time = d.pop("time", UNSET)

        tool_image = d.pop("tool_image", UNSET)

        tool_master_cmd = d.pop("tool_master_cmd", UNSET)

        tool_worker_cmd = d.pop("tool_worker_cmd", UNSET)

        train_image = d.pop("train_image", UNSET)

        train_master_cmd = d.pop("train_master_cmd", UNSET)

        train_worker_cmd = d.pop("train_worker_cmd", UNSET)

        job_spec = cls(
            artifact_dir=artifact_dir,
            cpus_per_task=cpus_per_task,
            env=env,
            gpus_per_node=gpus_per_node,
            log_dir=log_dir,
            master_strategy=master_strategy,
            mem=mem,
            mounts=mounts,
            nodes=nodes,
            num_tool_workers=num_tool_workers,
            num_train_workers=num_train_workers,
            partition=partition,
            proxy_image=proxy_image,
            qos=qos,
            run_dir=run_dir,
            time=time,
            tool_image=tool_image,
            tool_master_cmd=tool_master_cmd,
            tool_worker_cmd=tool_worker_cmd,
            train_image=train_image,
            train_master_cmd=train_master_cmd,
            train_worker_cmd=train_worker_cmd,
        )

        job_spec.additional_properties = d
        return job_spec

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
