## `mlte`: Machine Learning Test and Evaluation

<img src="https://raw.githubusercontent.com/mlte-team/mlte/master/assets/MLTE_Logo_Color.svg" alt="mlte_logo" width="150"/>

`mlte` (pronounced "melt") is a framework and infrastructure for machine learning evaluation.

![Version Badge](https://img.shields.io/badge/release-v1.0.2-e19b38)
[![Code Style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Tests](https://github.com/turingcompl33t/mlte/actions/workflows/ci.yaml/badge.svg)](https://github.com/turingcompl33t/mlte/actions/workflows/ci.yaml)
[![Documentation Status](https://readthedocs.org/projects/mlte/badge/?version=latest)](https://mlte.readthedocs.io/en/latest/?badge=latest)

### Getting Started

`mlte` is available on <a href="https://pypi.org/project/mlte-python/" target="_blank">PyPI</a>. Install the latest version with:

```bash
$ pip install mlte-python
```

You can go to our <a href="https://mlte.readthedocs.io/en/latest/setting_up_mlte/" target="_blank">setting up MLTE</a> page to see details on setting up and running MLTE. After that, you can head to our guide on <a href="https://mlte.readthedocs.io/en/latest/using_mlte/" target="_blank">using MLTE</a> for next steps. If you're interested in reading about the project more generally, see our <a href="https://mlte.readthedocs.io/en/latest/" target="_blank">documentation</a>.

### Citing This Work

If you're interested in learning more about this work, you can read our <a href="https://ieeexplore.ieee.org/document/10173876" target="_blank">paper</a>. While not required, it is highly encouraged and greatly appreciated if you cite our paper when you use MLTE for academic research.

```
@INPROCEEDINGS{10173876,
  author={Maffey, Katherine R. and Dotterrer, Kyle and Niemann, Jennifer and Cruickshank, Iain and Lewis, Grace A. and Kästner, Christian},
  booktitle={2023 IEEE/ACM 45th International Conference on Software Engineering: New Ideas and Emerging Results (ICSE-NIER)}, 
  title={MLTEing Models: Negotiating, Evaluating, and Documenting Model and System Qualities}, 
  year={2023},
  volume={},
  number={},
  pages={31-36},
  keywords={Measurement;Machine learning;Production;Organizations;Software;Stakeholders;Software engineering;machine learning;test and evaluation;machine learning evaluation;responsible AI},
  doi={10.1109/ICSE-NIER58687.2023.00012}
}
```