# Spec version 1.0.4
# This file is auto-generated by setup.py

from .base_types import AnnotationTypesBase


class AnnotationTypes(AnnotationTypesBase):
    """
    This class contains the CLAMS annotation types 
    defined in the spec version 1.0.4 as class variables. 
    """
    
    # prpoerty aliases, first added in MMIF 1.0.2
    # map from type short name to a dictionary of property aliases
    # where nested dictionary maps from representative name to its aliases
    _prop_aliases = {
        'TimeFrame': {'label': {'frameType', 'label'},
                      'classification': {'classifications', 'classification'}},
        'BoundingBox': {'label': {'boxType', 'label'}, 
                        'classification': {'classifications', 'classification'}},
        'Annotation': {'classification': {'classifications', 'classification'}},
        'Region': {'classification': {'classifications', 'classification'}},
        'Interval': {'classification': {'classifications', 'classification'}},
        'Span': {'classification': {'classifications', 'classification'}},
        'Chapter': {'classification': {'classifications', 'classification'}},
        'Polygon': {'classification': {'classifications', 'classification'}},
        'VideoObject': {'classification': {'classifications', 'classification'}},
        'Relation': {'classification': {'classifications', 'classification'}},
    }

    Annotation = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Annotation/v5')
    Region = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Region/v4')
    TimePoint = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/TimePoint/v4')
    Interval = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Interval/v4')
    Span = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Span/v4')
    TimeFrame = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/TimeFrame/v5')
    Chapter = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Chapter/v5')
    Polygon = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Polygon/v4')
    BoundingBox = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/BoundingBox/v4')
    VideoObject = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/VideoObject/v4')
    Relation = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Relation/v4')
    Alignment = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Alignment/v1')
    _typevers = {'Annotation': 'v5', 'Region': 'v4', 'TimePoint': 'v4', 'Interval': 'v4', 'Span': 'v4', 'TimeFrame': 'v5', 'Chapter': 'v5', 'Polygon': 'v4', 'BoundingBox': 'v4', 'VideoObject': 'v4', 'Relation': 'v4', 'Alignment': 'v1'}
