# Spec version 1.1.0
# This file is auto-generated by setup.py

from .base_types import AnnotationTypesBase


class AnnotationTypes(AnnotationTypesBase):
    """
    This class contains the CLAMS annotation types 
    defined in the spec version 1.1.0 as class variables. 
    """
    
    # prpoerty aliases, first added in MMIF 1.0.2
    # map from type short name to a dictionary of property aliases
    # where nested dictionary maps from representative name to its aliases
    _prop_aliases = {
        'TimeFrame': {'label': {'frameType', 'label'},
                      'classification': {'classifications', 'classification'}},
        'BoundingBox': {'label': {'boxType', 'label'}, 
                        'classification': {'classifications', 'classification'}},
        'Annotation': {'classification': {'classifications', 'classification'}},
        'Region': {'classification': {'classifications', 'classification'}},
        'Interval': {'classification': {'classifications', 'classification'}},
        'Span': {'classification': {'classifications', 'classification'}},
        'Chapter': {'classification': {'classifications', 'classification'}},
        'Polygon': {'classification': {'classifications', 'classification'}},
        'VideoObject': {'classification': {'classifications', 'classification'}},
        'Relation': {'classification': {'classifications', 'classification'}},
        'Span': {'text': {'word', 'text'}},
        'Token': {'text': {'word', 'text'}},
        'Sentence': {'text': {'word', 'text'}},
        'Paragraph': {'text': {'word', 'text'}},
        'NamedEntity': {'text': {'word', 'text'}},
        'NounChunk': {'text': {'word', 'text'}},
        'VerbChunk': {'text': {'word', 'text'}},
    }

    Annotation = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Annotation/v6')
    Region = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Region/v5')
    TimePoint = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/TimePoint/v5')
    Interval = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Interval/v5')
    Span = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Span/v5')
    Token = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Token/v1')
    Sentence = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Sentence/v1')
    Paragraph = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Paragraph/v1')
    NamedEntity = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/NamedEntity/v1')
    NounChunk = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/NounChunk/v1')
    VerbChunk = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/VerbChunk/v1')
    TimeFrame = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/TimeFrame/v6')
    Chapter = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Chapter/v6')
    Polygon = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Polygon/v5')
    BoundingBox = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/BoundingBox/v5')
    VideoObject = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/VideoObject/v5')
    Relation = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Relation/v5')
    Alignment = AnnotationTypesBase('http://mmif.clams.ai/vocabulary/Alignment/v1')
    _typevers = {'Annotation': 'v6', 'Region': 'v5', 'TimePoint': 'v5', 'Interval': 'v5', 'Span': 'v5', 'Token': 'v1', 'Sentence': 'v1', 'Paragraph': 'v1', 'NamedEntity': 'v1', 'NounChunk': 'v1', 'VerbChunk': 'v1', 'TimeFrame': 'v6', 'Chapter': 'v6', 'Polygon': 'v5', 'BoundingBox': 'v5', 'VideoObject': 'v5', 'Relation': 'v5', 'Alignment': 'v1'}
