# mms-python-client
Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 3.3.0
- Package version: 3.3.1-SNAPSHOT
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import mms-python-client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mms-python-client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import mms-python-client
from mms-python-client.rest import ApiException
from pprint import pprint

# Configure HTTP basic authorization: Basic
mms-python-client.configuration.username = 'YOUR_USERNAME'
mms-python-client.configuration.password = 'YOUR_PASSWORD'
# Configure API key authorization: Ticket
mms-python-client.configuration.api_key['alf_ticket'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# mms-python-client.configuration.api_key_prefix['alf_ticket'] = 'Bearer'
# create an instance of the API class
api_instance = mms-python-client.ArtifactApi()
project_id = 'project_id_example' # str | project identifier
ref_id = 'ref_id_example' # str | ref identifier
artifact_id = 'artifact_id_example' # str | artifact identifier

try:
    # Delete artifact
    api_response = api_instance.delete_artifact(project_id, ref_id, artifact_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ArtifactApi->delete_artifact: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://localhost/alfresco/service*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArtifactApi* | [**delete_artifact**](docs/ArtifactApi.md#delete_artifact) | **DELETE** /projects/{project_id}/refs/{ref_id}/artifacts/{artifact_id} | Delete artifact
*ArtifactApi* | [**delete_artifacts_in_batch**](docs/ArtifactApi.md#delete_artifacts_in_batch) | **DELETE** /projects/{project_id}/refs/{ref_id}/artifacts | Delete artifact(s) in batch
*ArtifactApi* | [**get_artifact**](docs/ArtifactApi.md#get_artifact) | **GET** /projects/{project_id}/refs/{ref_id}/artifacts/{artifact_id} | Get artifact
*ArtifactApi* | [**get_artifact_history**](docs/ArtifactApi.md#get_artifact_history) | **GET** /projects/{project_id}/refs/{ref_id}/artifacts/{artifact_id}/commits | Get artifact history
*ArtifactApi* | [**get_artifacts**](docs/ArtifactApi.md#get_artifacts) | **GET** /projects/{project_id}/refs/{ref_id}/artifacts | Get artifacts
*ArtifactApi* | [**get_artifacts_in_batch**](docs/ArtifactApi.md#get_artifacts_in_batch) | **PUT** /projects/{project_id}/refs/{ref_id}/artifacts | Get artifact(s) in batch
*ArtifactApi* | [**post_artifact**](docs/ArtifactApi.md#post_artifact) | **POST** /projects/{project_id}/refs/{ref_id}/artifacts | Create and/or update artifact
*ElementApi* | [**delete_element**](docs/ElementApi.md#delete_element) | **DELETE** /projects/{project_id}/refs/{ref_id}/elements/{element_id} | Delete element
*ElementApi* | [**delete_elements_in_batch**](docs/ElementApi.md#delete_elements_in_batch) | **DELETE** /projects/{project_id}/refs/{ref_id}/elements | Delete element(s) in batch
*ElementApi* | [**get_element**](docs/ElementApi.md#get_element) | **GET** /projects/{project_id}/refs/{ref_id}/elements/{element_id} | Get element
*ElementApi* | [**get_element_history**](docs/ElementApi.md#get_element_history) | **GET** /projects/{project_id}/refs/{ref_id}/elements/{element_id}/commits | Get element history
*ElementApi* | [**get_elements**](docs/ElementApi.md#get_elements) | **GET** /projects/{project_id}/refs/{ref_id}/elements | Get elements
*ElementApi* | [**get_elements_in_batch**](docs/ElementApi.md#get_elements_in_batch) | **PUT** /projects/{project_id}/refs/{ref_id}/elements | Get element(s) in batch
*ElementApi* | [**post_elements**](docs/ElementApi.md#post_elements) | **POST** /projects/{project_id}/refs/{ref_id}/elements | Create and/or update element(s)
*OrgApi* | [**delete_org**](docs/OrgApi.md#delete_org) | **DELETE** /orgs/{org_id} | Delete org
*OrgApi* | [**get_org**](docs/OrgApi.md#get_org) | **GET** /orgs/{org_id} | Get org
*OrgApi* | [**get_orgs**](docs/OrgApi.md#get_orgs) | **GET** /orgs | Get all orgs
*OrgApi* | [**post_orgs**](docs/OrgApi.md#post_orgs) | **POST** /orgs | Create and/or update org(s)
*OtherApi* | [**get_documents**](docs/OtherApi.md#get_documents) | **GET** /projects/{project_id}/refs/{ref_id}/documents | Get documents
*OtherApi* | [**get_groups**](docs/OtherApi.md#get_groups) | **GET** /projects/{project_id}/refs/{ref_id}/groups | Get groups
*OtherApi* | [**get_mounts**](docs/OtherApi.md#get_mounts) | **GET** /projects/{project_id}/refs/{ref_id}/mounts | Get mounts
*ProjectApi* | [**delete_project**](docs/ProjectApi.md#delete_project) | **DELETE** /projects/{project_id} | Delete project
*ProjectApi* | [**get_project**](docs/ProjectApi.md#get_project) | **GET** /projects/{project_id} | Get project
*ProjectApi* | [**get_project_commit**](docs/ProjectApi.md#get_project_commit) | **GET** /projects/{project_id}/commits/{commit_id} | Get project commit
*ProjectApi* | [**get_projects**](docs/ProjectApi.md#get_projects) | **GET** /projects | Get all projects
*ProjectApi* | [**get_projects_by_org**](docs/ProjectApi.md#get_projects_by_org) | **GET** /orgs/{org_id}/projects | Get all projects in org
*ProjectApi* | [**post_projects**](docs/ProjectApi.md#post_projects) | **POST** /projects | Create and/or update project(s)
*ProjectApi* | [**post_projects_by_org**](docs/ProjectApi.md#post_projects_by_org) | **POST** /orgs/{org_id}/projects | Create and/or update project(s) in org
*RefApi* | [**delete_ref**](docs/RefApi.md#delete_ref) | **DELETE** /projects/{project_id}/refs/{ref_id} | Delete ref
*RefApi* | [**get_ref**](docs/RefApi.md#get_ref) | **GET** /projects/{project_id}/refs/{ref_id} | Get ref
*RefApi* | [**get_ref_history**](docs/RefApi.md#get_ref_history) | **GET** /projects/{project_id}/refs/{ref_id}/commits | Get ref history
*RefApi* | [**get_refs**](docs/RefApi.md#get_refs) | **GET** /projects/{project_id}/refs | Get all refs in project
*RefApi* | [**post_refs**](docs/RefApi.md#post_refs) | **POST** /projects/{project_id}/refs | Create and/or update ref(s)
*TicketApi* | [**get_ticket**](docs/TicketApi.md#get_ticket) | **GET** /mms/login/ticket/{ticket_id} | Get ticket
*TicketApi* | [**post_ticket**](docs/TicketApi.md#post_ticket) | **POST** /api/login | Create ticket


## Documentation For Models

 - [Artifact](docs/Artifact.md)
 - [Artifacts](docs/Artifacts.md)
 - [Commit](docs/Commit.md)
 - [Commits](docs/Commits.md)
 - [Documents](docs/Documents.md)
 - [Element](docs/Element.md)
 - [Elements](docs/Elements.md)
 - [Groups](docs/Groups.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [LoginResponseData](docs/LoginResponseData.md)
 - [Mounts](docs/Mounts.md)
 - [Org](docs/Org.md)
 - [Orgs](docs/Orgs.md)
 - [Project](docs/Project.md)
 - [Projects](docs/Projects.md)
 - [Ref](docs/Ref.md)
 - [Refs](docs/Refs.md)
 - [RejectableElements](docs/RejectableElements.md)
 - [Rejection](docs/Rejection.md)
 - [TicketResponse](docs/TicketResponse.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication

## Ticket

- **Type**: API key
- **API key parameter name**: alf_ticket
- **Location**: URL query string


## Author



