# coding: utf-8

"""
    Model Management Service

    Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.  # noqa: E501

    OpenAPI spec version: 3.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mms-python-client.api_client import ApiClient


class RefApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_ref(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Delete ref  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_ref(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_ref_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_ref_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def delete_ref_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Delete ref  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_ref_with_http_info(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ref" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_ref`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `delete_ref`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Refs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ref(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get ref  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_ref(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_ref_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ref_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def get_ref_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get ref  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_ref_with_http_info(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ref" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_ref`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_ref`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Refs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ref_history(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get ref history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_ref_history(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_ref_history_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ref_history_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def get_ref_history_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get ref history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_ref_history_with_http_info(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ref_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_ref_history`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_ref_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/commits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Commits',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_refs(self, project_id, **kwargs):  # noqa: E501
        """Get all refs in project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_refs(project_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_refs_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_refs_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_refs_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Get all refs in project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_refs_with_http_info(project_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_refs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_refs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Refs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_refs(self, project_id, body, **kwargs):  # noqa: E501
        """Create and/or update ref(s)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_refs(project_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param Refs body:  (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.post_refs_with_http_info(project_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_refs_with_http_info(project_id, body, **kwargs)  # noqa: E501
            return data

    def post_refs_with_http_info(self, project_id, body, **kwargs):  # noqa: E501
        """Create and/or update ref(s)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_refs_with_http_info(project_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param Refs body:  (required)
        :return: Refs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_refs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `post_refs`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_refs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Refs',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
