# coding: utf-8

"""
    Model Management Service

    Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.  # noqa: E501

    OpenAPI spec version: 3.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mms-python-client.api_client import ApiClient


class ArtifactApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_artifact(self, project_id, ref_id, artifact_id, **kwargs):  # noqa: E501
        """Delete artifact  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_artifact(project_id, ref_id, artifact_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str artifact_id: artifact identifier (required)
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_artifact_with_http_info(project_id, ref_id, artifact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_artifact_with_http_info(project_id, ref_id, artifact_id, **kwargs)  # noqa: E501
            return data

    def delete_artifact_with_http_info(self, project_id, ref_id, artifact_id, **kwargs):  # noqa: E501
        """Delete artifact  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_artifact_with_http_info(project_id, ref_id, artifact_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str artifact_id: artifact identifier (required)
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'artifact_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_artifact`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `delete_artifact`")  # noqa: E501
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params or
                params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `delete_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501
        if 'artifact_id' in params:
            path_params['artifact_id'] = params['artifact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts/{artifact_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifacts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_artifacts_in_batch(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Delete artifact(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_artifacts_in_batch(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Artifacts body:  (required)
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_artifacts_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_artifacts_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def delete_artifacts_in_batch_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Delete artifact(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_artifacts_in_batch_with_http_info(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Artifacts body:  (required)
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_artifacts_in_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_artifacts_in_batch`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `delete_artifacts_in_batch`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_artifacts_in_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifacts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifact(self, project_id, ref_id, artifact_id, **kwargs):  # noqa: E501
        """Get artifact  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifact(project_id, ref_id, artifact_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str artifact_id: artifact identifier (required)
        :param int depth: 
        :param bool extended: 
        :param str commit_id: 
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_artifact_with_http_info(project_id, ref_id, artifact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifact_with_http_info(project_id, ref_id, artifact_id, **kwargs)  # noqa: E501
            return data

    def get_artifact_with_http_info(self, project_id, ref_id, artifact_id, **kwargs):  # noqa: E501
        """Get artifact  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifact_with_http_info(project_id, ref_id, artifact_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str artifact_id: artifact identifier (required)
        :param int depth: 
        :param bool extended: 
        :param str commit_id: 
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'artifact_id', 'depth', 'extended', 'commit_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_artifact`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_artifact`")  # noqa: E501
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params or
                params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501
        if 'artifact_id' in params:
            path_params['artifact_id'] = params['artifact_id']  # noqa: E501

        query_params = []
        if 'depth' in params:
            query_params.append(('depth', params['depth']))  # noqa: E501
        if 'extended' in params:
            query_params.append(('extended', params['extended']))  # noqa: E501
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts/{artifact_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifacts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifact_history(self, project_id, ref_id, artifact_id, **kwargs):  # noqa: E501
        """Get artifact history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifact_history(project_id, ref_id, artifact_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str artifact_id: artifact identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_artifact_history_with_http_info(project_id, ref_id, artifact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifact_history_with_http_info(project_id, ref_id, artifact_id, **kwargs)  # noqa: E501
            return data

    def get_artifact_history_with_http_info(self, project_id, ref_id, artifact_id, **kwargs):  # noqa: E501
        """Get artifact history  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifact_history_with_http_info(project_id, ref_id, artifact_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str artifact_id: artifact identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'artifact_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifact_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_artifact_history`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_artifact_history`")  # noqa: E501
        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params or
                params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_artifact_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501
        if 'artifact_id' in params:
            path_params['artifact_id'] = params['artifact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts/{artifact_id}/commits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Commits',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifacts(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get artifacts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifacts(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str commit_id: 
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_artifacts_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifacts_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def get_artifacts_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get artifacts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifacts_with_http_info(project_id, ref_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str commit_id: 
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'commit_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_artifacts`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_artifacts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifacts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifacts_in_batch(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Get artifact(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifacts_in_batch(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Artifacts body:  (required)
        :param str commit_id: 
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_artifacts_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifacts_in_batch_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def get_artifacts_in_batch_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Get artifact(s) in batch  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_artifacts_in_batch_with_http_info(project_id, ref_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param Artifacts body:  (required)
        :param str commit_id: 
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body', 'commit_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifacts_in_batch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_artifacts_in_batch`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_artifacts_in_batch`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_artifacts_in_batch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []
        if 'commit_id' in params:
            query_params.append(('commitId', params['commit_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifacts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_artifact(self, project_id, ref_id, id, file, **kwargs):  # noqa: E501
        """Create and/or update artifact  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_artifact(project_id, ref_id, id, file, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str id: (required)
        :param file file: (required)
        :param str content_type: When the content type cannot be automatically detected, this explicitly defined value is used.
        :param str name:
        :param str source:
        :param str comment:
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.post_artifact_with_http_info(project_id, ref_id, id, file, **kwargs)  # noqa: E501
        else:
            (data) = self.post_artifact_with_http_info(project_id, ref_id, id, file, **kwargs)  # noqa: E501
            return data

    def post_artifact_with_http_info(self, project_id, ref_id, id, file, **kwargs):  # noqa: E501
        """Create and/or update artifact  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_artifact_with_http_info(project_id, ref_id, id, file, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param str id: (required)
        :param file file: (required)
        :param str content_type: When the content type cannot be automatically detected, this explicitly defined value is used.
        :param str name:
        :param str source:
        :param str comment:
        :return: Artifacts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'id', 'file', 'content_type', 'name', 'source', 'comment']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `post_artifact`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `post_artifact`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `post_artifact`")  # noqa: E501
        # verify the required parameter 'file' is set
        if ('file' not in params or
                params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `post_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'id' in params:
            form_params.append(('id', params['id']))  # noqa: E501
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501
        if 'content_type' in params:
            form_params.append(('contentType', params['content_type']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'source' in params:
            form_params.append(('source', params['source']))  # noqa: E501
        if 'comment' in params:
            form_params.append(('comment', params['comment']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/artifacts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifacts',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
