# coding: utf-8

"""
    Model Management Service

    Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.  # noqa: E501

    OpenAPI spec version: 3.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mms_python_client.api_client import ApiClient


class ProjectApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_project(self, project_id, **kwargs):  # noqa: E501
        """Delete project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_project(project_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_project_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_project_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def delete_project_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Delete project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_project_with_http_info(project_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `delete_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project(self, project_id, **kwargs):  # noqa: E501
        """Get project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_project(project_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_project_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_project_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Get project  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_project_with_http_info(project_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_commit(self, project_id, commit_id, **kwargs):  # noqa: E501
        """Get project commit  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_project_commit(project_id, commit_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str commit_id: commit identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_project_commit_with_http_info(project_id, commit_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_commit_with_http_info(project_id, commit_id, **kwargs)  # noqa: E501
            return data

    def get_project_commit_with_http_info(self, project_id, commit_id, **kwargs):  # noqa: E501
        """Get project commit  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_project_commit_with_http_info(project_id, commit_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str project_id: project identifier (required)
        :param str commit_id: commit identifier (required)
        :return: Commits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'commit_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_commit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_project_commit`")  # noqa: E501
        # verify the required parameter 'commit_id' is set
        if ('commit_id' not in params or
                params['commit_id'] is None):
            raise ValueError("Missing the required parameter `commit_id` when calling `get_project_commit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'commit_id' in params:
            path_params['commit_id'] = params['commit_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/commits/{commit_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Commits',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_projects(self, **kwargs):  # noqa: E501
        """Get all projects  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_projects(async=True)
        >>> result = thread.get()

        :param async bool
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_projects_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_projects_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_projects_with_http_info(self, **kwargs):  # noqa: E501
        """Get all projects  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_projects_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_projects" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_projects_by_org(self, org_id, **kwargs):  # noqa: E501
        """Get all projects in org  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_projects_by_org(org_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str org_id: org identifier (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_projects_by_org_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_projects_by_org_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_projects_by_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """Get all projects in org  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_projects_by_org_with_http_info(org_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str org_id: org identifier (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_projects_by_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_projects_by_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['org_id'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org_id}/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_projects(self, body, **kwargs):  # noqa: E501
        """Create and/or update project(s)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_projects(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param Projects body:  (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.post_projects_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_projects_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_projects_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create and/or update project(s)  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_projects_with_http_info(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param Projects body:  (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_projects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_projects`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_projects_by_org(self, org_id, body, **kwargs):  # noqa: E501
        """Create and/or update project(s) in org  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_projects_by_org(org_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str org_id: org identifier (required)
        :param Projects body:  (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.post_projects_by_org_with_http_info(org_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_projects_by_org_with_http_info(org_id, body, **kwargs)  # noqa: E501
            return data

    def post_projects_by_org_with_http_info(self, org_id, body, **kwargs):  # noqa: E501
        """Create and/or update project(s) in org  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.post_projects_by_org_with_http_info(org_id, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str org_id: org identifier (required)
        :param Projects body:  (required)
        :return: Projects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_id', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_projects_by_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in params or
                params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `post_projects_by_org`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_projects_by_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_id' in params:
            path_params['org_id'] = params['org_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org_id}/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Projects',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
