# coding: utf-8

"""
    Model Management Service

    Model Management System (MMS) is a version control system for structured data. It exposes model information through RESTful web services that can be used for CRUD operations, branching, and tagging of the model repository.  # noqa: E501

    OpenAPI spec version: 3.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mms_python_client.api_client import ApiClient


class OtherApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_groups(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groups(project_id, ref_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Groups
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_groups_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_groups_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def get_groups_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get groups  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groups_with_http_info(project_id, ref_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Groups
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_groups`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_groups`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Groups',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mounts(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get mounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mounts(project_id, ref_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Mounts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mounts_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_mounts_with_http_info(project_id, ref_id, **kwargs)  # noqa: E501
            return data

    def get_mounts_with_http_info(self, project_id, ref_id, **kwargs):  # noqa: E501
        """Get mounts  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mounts_with_http_info(project_id, ref_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :return: Mounts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `get_mounts`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `get_mounts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/mounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Mounts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def html_converter(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Converts HTML to requested format  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.html_converter(project_id, ref_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param ConvertRequest body:  (required)
        :return: ConvertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.html_converter_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.html_converter_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def html_converter_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Converts HTML to requested format  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.html_converter_with_http_info(project_id, ref_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param ConvertRequest body:  (required)
        :return: ConvertResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method html_converter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `html_converter`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `html_converter`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `html_converter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/convert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConvertResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_elements(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Search for elements  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_elements(project_id, ref_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param SearchRequest body:  (required)
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_elements_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.search_elements_with_http_info(project_id, ref_id, body, **kwargs)  # noqa: E501
            return data

    def search_elements_with_http_info(self, project_id, ref_id, body, **kwargs):  # noqa: E501
        """Search for elements  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_elements_with_http_info(project_id, ref_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: project identifier (required)
        :param str ref_id: ref identifier (required)
        :param SearchRequest body:  (required)
        :return: Elements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'ref_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_elements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `search_elements`")  # noqa: E501
        # verify the required parameter 'ref_id' is set
        if ('ref_id' not in params or
                params['ref_id'] is None):
            raise ValueError("Missing the required parameter `ref_id` when calling `search_elements`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `search_elements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'ref_id' in params:
            path_params['ref_id'] = params['ref_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['Basic', 'Ticket']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_id}/refs/{ref_id}/search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Elements',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
