# mms-python-client
Documentation for MMS API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 4.0.0-alpha.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import mms_python_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mms_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import mms_python_client
from mms_python_client.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost:8080
configuration.host = "http://localhost:8080"
# Create an instance of the API class
api_instance = mms_python_client.AuthenticationControllerApi(mms_python_client.ApiClient(configuration))
jwt_authentication_request = mms_python_client.JwtAuthenticationRequest() # JwtAuthenticationRequest |  (optional)

try:
    api_response = api_instance.create_authentication_token(jwt_authentication_request=jwt_authentication_request)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthenticationControllerApi->create_authentication_token: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationControllerApi* | [**create_authentication_token**](docs/AuthenticationControllerApi.md#create_authentication_token) | **POST** /authentication | 
*AuthenticationControllerApi* | [**create_user**](docs/AuthenticationControllerApi.md#create_user) | **POST** /user | 
*BranchesControllerApi* | [**create_branches**](docs/BranchesControllerApi.md#create_branches) | **POST** /projects/{projectId}/refs | 
*BranchesControllerApi* | [**delete_branch**](docs/BranchesControllerApi.md#delete_branch) | **DELETE** /projects/{projectId}/refs/{refId} | 
*BranchesControllerApi* | [**get_all_branches**](docs/BranchesControllerApi.md#get_all_branches) | **GET** /projects/{projectId}/refs | 
*BranchesControllerApi* | [**get_branch**](docs/BranchesControllerApi.md#get_branch) | **GET** /projects/{projectId}/refs/{refId} | 
*CommitsControllerApi* | [**get_all_commits**](docs/CommitsControllerApi.md#get_all_commits) | **GET** /projects/{projectId}/refs/{refId}/commits | 
*CommitsControllerApi* | [**get_commit**](docs/CommitsControllerApi.md#get_commit) | **GET** /projects/{projectId}/commits/{commitId} | 
*CommitsControllerApi* | [**get_commits**](docs/CommitsControllerApi.md#get_commits) | **PUT** /projects/{projectId}/commits | 
*CommitsControllerApi* | [**get_element_commits**](docs/CommitsControllerApi.md#get_element_commits) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId}/commits | 
*ElementsControllerApi* | [**create_or_update_elements**](docs/ElementsControllerApi.md#create_or_update_elements) | **POST** /projects/{projectId}/refs/{refId}/elements | 
*ElementsControllerApi* | [**delete_element**](docs/ElementsControllerApi.md#delete_element) | **DELETE** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ElementsControllerApi* | [**delete_elements**](docs/ElementsControllerApi.md#delete_elements) | **DELETE** /projects/{projectId}/refs/{refId}/elements | 
*ElementsControllerApi* | [**get_all_elements**](docs/ElementsControllerApi.md#get_all_elements) | **GET** /projects/{projectId}/refs/{refId}/elements | 
*ElementsControllerApi* | [**get_element**](docs/ElementsControllerApi.md#get_element) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ElementsControllerApi* | [**get_elements**](docs/ElementsControllerApi.md#get_elements) | **PUT** /projects/{projectId}/refs/{refId}/elements | 
*HealthCheckControllerApi* | [**healthcheck**](docs/HealthCheckControllerApi.md#healthcheck) | **GET** /healthcheck | 
*NotebooksControllerApi* | [**create_or_update_notebooks**](docs/NotebooksControllerApi.md#create_or_update_notebooks) | **POST** /projects/{projectId}/refs/{refId}/notebooks | 
*NotebooksControllerApi* | [**get_all_notebooks**](docs/NotebooksControllerApi.md#get_all_notebooks) | **GET** /projects/{projectId}/refs/{refId}/notebooks | 
*NotebooksControllerApi* | [**get_notebook**](docs/NotebooksControllerApi.md#get_notebook) | **GET** /projects/{projectId}/refs/{refId}/notebooks/{notebookId} | 
*NotebooksControllerApi* | [**get_notebooks**](docs/NotebooksControllerApi.md#get_notebooks) | **PUT** /projects/{projectId}/refs/{refId}/notebooks | 
*OrgsControllerApi* | [**create_or_update_orgs**](docs/OrgsControllerApi.md#create_or_update_orgs) | **POST** /orgs | 
*OrgsControllerApi* | [**delete_org**](docs/OrgsControllerApi.md#delete_org) | **DELETE** /orgs/{orgId} | 
*OrgsControllerApi* | [**get_all_orgs**](docs/OrgsControllerApi.md#get_all_orgs) | **GET** /orgs | 
*OrgsControllerApi* | [**get_org**](docs/OrgsControllerApi.md#get_org) | **GET** /orgs/{orgId} | 
*PermissionsControllerApi* | [**get_branch_permissions**](docs/PermissionsControllerApi.md#get_branch_permissions) | **GET** /projects/{projectId}/refs/{refId}/permissions | 
*PermissionsControllerApi* | [**get_org_permissions**](docs/PermissionsControllerApi.md#get_org_permissions) | **GET** /orgs/{orgId}/permissions | 
*PermissionsControllerApi* | [**get_project_permissions**](docs/PermissionsControllerApi.md#get_project_permissions) | **GET** /projects/{projectId}/permissions | 
*PermissionsControllerApi* | [**update_branch_permissions**](docs/PermissionsControllerApi.md#update_branch_permissions) | **POST** /projects/{projectId}/refs/{refId}/permissions | 
*PermissionsControllerApi* | [**update_org_permissions**](docs/PermissionsControllerApi.md#update_org_permissions) | **POST** /orgs/{orgId}/permissions | 
*PermissionsControllerApi* | [**update_project_permissions**](docs/PermissionsControllerApi.md#update_project_permissions) | **POST** /projects/{projectId}/permissions | 
*PermissionsLookupControllerApi* | [**lookup_permissions**](docs/PermissionsLookupControllerApi.md#lookup_permissions) | **POST** /permissions | 
*ProjectsControllerApi* | [**create_or_update_projects**](docs/ProjectsControllerApi.md#create_or_update_projects) | **POST** /projects | 
*ProjectsControllerApi* | [**delete_project**](docs/ProjectsControllerApi.md#delete_project) | **DELETE** /projects/{projectId} | 
*ProjectsControllerApi* | [**get_all_projects**](docs/ProjectsControllerApi.md#get_all_projects) | **GET** /projects | 
*ProjectsControllerApi* | [**get_project**](docs/ProjectsControllerApi.md#get_project) | **GET** /projects/{projectId} | 
*WebhooksControllerApi* | [**create_or_update_webhooks**](docs/WebhooksControllerApi.md#create_or_update_webhooks) | **POST** /projects/{projectId}/webhooks | 
*WebhooksControllerApi* | [**delete_webhooks**](docs/WebhooksControllerApi.md#delete_webhooks) | **DELETE** /projects/{projectId}/webhooks | 
*WebhooksControllerApi* | [**get_all_webhooks**](docs/WebhooksControllerApi.md#get_all_webhooks) | **GET** /projects/{projectId}/webhooks | 


## Documentation For Models

 - [BranchesRequest](docs/BranchesRequest.md)
 - [BranchesResponse](docs/BranchesResponse.md)
 - [CommitJson](docs/CommitJson.md)
 - [CommitsRequest](docs/CommitsRequest.md)
 - [CommitsResponse](docs/CommitsResponse.md)
 - [ElementsRequest](docs/ElementsRequest.md)
 - [ElementsResponse](docs/ElementsResponse.md)
 - [JwtAuthenticationRequest](docs/JwtAuthenticationRequest.md)
 - [JwtAuthenticationResponse](docs/JwtAuthenticationResponse.md)
 - [NotebooksRequest](docs/NotebooksRequest.md)
 - [NotebooksResponse](docs/NotebooksResponse.md)
 - [OrgJson](docs/OrgJson.md)
 - [OrganizationsRequest](docs/OrganizationsRequest.md)
 - [OrganizationsResponse](docs/OrganizationsResponse.md)
 - [Permission](docs/Permission.md)
 - [PermissionLookup](docs/PermissionLookup.md)
 - [PermissionLookupRequest](docs/PermissionLookupRequest.md)
 - [PermissionLookupResponse](docs/PermissionLookupResponse.md)
 - [PermissionResponse](docs/PermissionResponse.md)
 - [PermissionUpdateRequest](docs/PermissionUpdateRequest.md)
 - [PermissionsRequest](docs/PermissionsRequest.md)
 - [PermissionsResponse](docs/PermissionsResponse.md)
 - [ProjectJson](docs/ProjectJson.md)
 - [ProjectsRequest](docs/ProjectsRequest.md)
 - [ProjectsResponse](docs/ProjectsResponse.md)
 - [RefJson](docs/RefJson.md)
 - [Rejection](docs/Rejection.md)
 - [WebhookJson](docs/WebhookJson.md)
 - [WebhookRequest](docs/WebhookRequest.md)
 - [WebhookResponse](docs/WebhookResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## bearerToken

- **Type**: Bearer authentication (JWT)


## Author




