# mms-python-client
Documentation for MMS API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 4.0.0.a3
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import mms_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mms_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import mms_python_client
from mms_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = mms_python_client.Configuration(
    host = "http://localhost:8080"
)



# Enter a context with an instance of the API client
with mms_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = mms_python_client.AuthApi(api_client)
    jwt_authentication_request = mms_python_client.JwtAuthenticationRequest() # JwtAuthenticationRequest | 

    try:
        api_response = api_instance.create_authentication_token(jwt_authentication_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthApi->create_authentication_token: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**create_authentication_token**](docs/AuthApi.md#create_authentication_token) | **POST** /authentication | 
*AuthApi* | [**create_user**](docs/AuthApi.md#create_user) | **POST** /user | 
*AuthApi* | [**get_branch_permissions**](docs/AuthApi.md#get_branch_permissions) | **GET** /projects/{projectId}/refs/{refId}/permissions | 
*AuthApi* | [**get_org_permissions**](docs/AuthApi.md#get_org_permissions) | **GET** /orgs/{orgId}/permissions | 
*AuthApi* | [**get_project_permissions**](docs/AuthApi.md#get_project_permissions) | **GET** /projects/{projectId}/permissions | 
*AuthApi* | [**lookup_permissions**](docs/AuthApi.md#lookup_permissions) | **PUT** /permissions | 
*AuthApi* | [**update_branch_permissions**](docs/AuthApi.md#update_branch_permissions) | **POST** /projects/{projectId}/refs/{refId}/permissions | 
*AuthApi* | [**update_org_permissions**](docs/AuthApi.md#update_org_permissions) | **POST** /orgs/{orgId}/permissions | 
*AuthApi* | [**update_password**](docs/AuthApi.md#update_password) | **POST** /password | 
*AuthApi* | [**update_project_permissions**](docs/AuthApi.md#update_project_permissions) | **POST** /projects/{projectId}/permissions | 
*CommitsApi* | [**get_commit**](docs/CommitsApi.md#get_commit) | **GET** /projects/{projectId}/commits/{commitId} | 
*CommitsApi* | [**get_commits**](docs/CommitsApi.md#get_commits) | **PUT** /projects/{projectId}/commits | 
*CommitsApi* | [**get_element_commits**](docs/CommitsApi.md#get_element_commits) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId}/commits | 
*CommitsApi* | [**get_ref_commits**](docs/CommitsApi.md#get_ref_commits) | **GET** /projects/{projectId}/refs/{refId}/commits | 
*ElementsApi* | [**create_or_update_elements**](docs/ElementsApi.md#create_or_update_elements) | **POST** /projects/{projectId}/refs/{refId}/elements | 
*ElementsApi* | [**delete_element**](docs/ElementsApi.md#delete_element) | **DELETE** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ElementsApi* | [**delete_elements**](docs/ElementsApi.md#delete_elements) | **DELETE** /projects/{projectId}/refs/{refId}/elements | 
*ElementsApi* | [**get_all_elements**](docs/ElementsApi.md#get_all_elements) | **GET** /projects/{projectId}/refs/{refId}/elements | 
*ElementsApi* | [**get_element**](docs/ElementsApi.md#get_element) | **GET** /projects/{projectId}/refs/{refId}/elements/{elementId} | 
*ElementsApi* | [**get_elements**](docs/ElementsApi.md#get_elements) | **PUT** /projects/{projectId}/refs/{refId}/elements | 
*MonitorApi* | [**healthcheck**](docs/MonitorApi.md#healthcheck) | **GET** /healthcheck | 
*NotebooksApi* | [**create_or_update_notebooks**](docs/NotebooksApi.md#create_or_update_notebooks) | **POST** /projects/{projectId}/refs/{refId}/notebooks | 
*NotebooksApi* | [**get_all_notebooks**](docs/NotebooksApi.md#get_all_notebooks) | **GET** /projects/{projectId}/refs/{refId}/notebooks | 
*NotebooksApi* | [**get_notebook**](docs/NotebooksApi.md#get_notebook) | **GET** /projects/{projectId}/refs/{refId}/notebooks/{notebookId} | 
*NotebooksApi* | [**get_notebooks**](docs/NotebooksApi.md#get_notebooks) | **PUT** /projects/{projectId}/refs/{refId}/notebooks | 
*OrgsApi* | [**create_or_update_orgs**](docs/OrgsApi.md#create_or_update_orgs) | **POST** /orgs | 
*OrgsApi* | [**delete_org**](docs/OrgsApi.md#delete_org) | **DELETE** /orgs/{orgId} | 
*OrgsApi* | [**get_all_orgs**](docs/OrgsApi.md#get_all_orgs) | **GET** /orgs | 
*OrgsApi* | [**get_org**](docs/OrgsApi.md#get_org) | **GET** /orgs/{orgId} | 
*ProjectsApi* | [**create_or_update_projects**](docs/ProjectsApi.md#create_or_update_projects) | **POST** /projects | 
*ProjectsApi* | [**delete_project**](docs/ProjectsApi.md#delete_project) | **DELETE** /projects/{projectId} | 
*ProjectsApi* | [**get_all_projects**](docs/ProjectsApi.md#get_all_projects) | **GET** /projects | 
*ProjectsApi* | [**get_project**](docs/ProjectsApi.md#get_project) | **GET** /projects/{projectId} | 
*ProjectsApi* | [**get_project_schema_options**](docs/ProjectsApi.md#get_project_schema_options) | **GET** /schemas | 
*RefsApi* | [**create_refs**](docs/RefsApi.md#create_refs) | **POST** /projects/{projectId}/refs | 
*RefsApi* | [**delete_ref**](docs/RefsApi.md#delete_ref) | **DELETE** /projects/{projectId}/refs/{refId} | 
*RefsApi* | [**get_all_refs**](docs/RefsApi.md#get_all_refs) | **GET** /projects/{projectId}/refs | 
*RefsApi* | [**get_ref**](docs/RefsApi.md#get_ref) | **GET** /projects/{projectId}/refs/{refId} | 
*ViewsApi* | [**create_or_update_views**](docs/ViewsApi.md#create_or_update_views) | **POST** /projects/{projectId}/refs/{refId}/views | 
*ViewsApi* | [**get_documents**](docs/ViewsApi.md#get_documents) | **GET** /projects/{projectId}/refs/{refId}/documents | 
*ViewsApi* | [**get_groups**](docs/ViewsApi.md#get_groups) | **GET** /projects/{projectId}/refs/{refId}/groups | 
*ViewsApi* | [**get_mounts**](docs/ViewsApi.md#get_mounts) | **GET** /projects/{projectId}/refs/{refId}/mounts | 
*ViewsApi* | [**get_view**](docs/ViewsApi.md#get_view) | **GET** /projects/{projectId}/refs/{refId}/views/{viewId} | 
*ViewsApi* | [**get_views**](docs/ViewsApi.md#get_views) | **PUT** /projects/{projectId}/refs/{refId}/views | 
*WebhooksApi* | [**create_or_update_webhooks**](docs/WebhooksApi.md#create_or_update_webhooks) | **POST** /projects/{projectId}/webhooks | 
*WebhooksApi* | [**delete_webhooks**](docs/WebhooksApi.md#delete_webhooks) | **DELETE** /projects/{projectId}/webhooks | 
*WebhooksApi* | [**get_all_webhooks**](docs/WebhooksApi.md#get_all_webhooks) | **GET** /projects/{projectId}/webhooks | 


## Documentation For Models

 - [Commit](docs/Commit.md)
 - [CommitsRequest](docs/CommitsRequest.md)
 - [CommitsResponse](docs/CommitsResponse.md)
 - [DocumentsResponse](docs/DocumentsResponse.md)
 - [ElementVersion](docs/ElementVersion.md)
 - [ElementsRequest](docs/ElementsRequest.md)
 - [ElementsResponse](docs/ElementsResponse.md)
 - [GroupsResponse](docs/GroupsResponse.md)
 - [JwtAuthenticationRequest](docs/JwtAuthenticationRequest.md)
 - [JwtAuthenticationResponse](docs/JwtAuthenticationResponse.md)
 - [Mount](docs/Mount.md)
 - [MountsResponse](docs/MountsResponse.md)
 - [NotebooksRequest](docs/NotebooksRequest.md)
 - [NotebooksResponse](docs/NotebooksResponse.md)
 - [Org](docs/Org.md)
 - [OrganizationsRequest](docs/OrganizationsRequest.md)
 - [OrganizationsResponse](docs/OrganizationsResponse.md)
 - [Permission](docs/Permission.md)
 - [PermissionLookup](docs/PermissionLookup.md)
 - [PermissionLookupRequest](docs/PermissionLookupRequest.md)
 - [PermissionLookupResponse](docs/PermissionLookupResponse.md)
 - [PermissionResponse](docs/PermissionResponse.md)
 - [PermissionUpdate](docs/PermissionUpdate.md)
 - [PermissionUpdateRequest](docs/PermissionUpdateRequest.md)
 - [PermissionUpdateResponse](docs/PermissionUpdateResponse.md)
 - [PermissionUpdatesResponse](docs/PermissionUpdatesResponse.md)
 - [PermissionsRequest](docs/PermissionsRequest.md)
 - [PermissionsResponse](docs/PermissionsResponse.md)
 - [Project](docs/Project.md)
 - [ProjectsRequest](docs/ProjectsRequest.md)
 - [ProjectsResponse](docs/ProjectsResponse.md)
 - [Ref](docs/Ref.md)
 - [RefsRequest](docs/RefsRequest.md)
 - [RefsResponse](docs/RefsResponse.md)
 - [Rejection](docs/Rejection.md)
 - [Schema](docs/Schema.md)
 - [SchemasResponse](docs/SchemasResponse.md)
 - [UserCreateRequest](docs/UserCreateRequest.md)
 - [Webhook](docs/Webhook.md)
 - [WebhookRequest](docs/WebhookRequest.md)
 - [WebhookResponse](docs/WebhookResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## bearerToken

- **Type**: Bearer authentication (JWT)


## Author




