"""
    MMS Reference Implementation API

    Documentation for MMS API  # noqa: E501

    The version of the OpenAPI document: 4.0.4
    Contact: mms@openmbee.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from mms_python_client.api_client import ApiClient, Endpoint as _Endpoint
from mms_python_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from mms_python_client.model.commits_request import CommitsRequest
from mms_python_client.model.commits_response import CommitsResponse


class CommitsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_commit(
            self,
            project_id,
            commit_id,
            **kwargs
        ):
            """get_commit  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_commit(project_id, commit_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str):
                commit_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommitsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['commit_id'] = \
                commit_id
            return self.call_with_http_info(**kwargs)

        self.get_commit = _Endpoint(
            settings={
                'response_type': (CommitsResponse,),
                'auth': [
                    'basicAuth',
                    'bearerToken'
                ],
                'endpoint_path': '/projects/{projectId}/commits/{commitId}',
                'operation_id': 'get_commit',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'commit_id',
                ],
                'required': [
                    'project_id',
                    'commit_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'commit_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'commit_id': 'commitId',
                },
                'location_map': {
                    'project_id': 'path',
                    'commit_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_commit
        )

        def __get_commits(
            self,
            project_id,
            commits_request,
            **kwargs
        ):
            """get_commits  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_commits(project_id, commits_request, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str):
                commits_request (CommitsRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommitsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['commits_request'] = \
                commits_request
            return self.call_with_http_info(**kwargs)

        self.get_commits = _Endpoint(
            settings={
                'response_type': (CommitsResponse,),
                'auth': [
                    'basicAuth',
                    'bearerToken'
                ],
                'endpoint_path': '/projects/{projectId}/commits',
                'operation_id': 'get_commits',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'commits_request',
                ],
                'required': [
                    'project_id',
                    'commits_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'commits_request':
                        (CommitsRequest,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                },
                'location_map': {
                    'project_id': 'path',
                    'commits_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__get_commits
        )

        def __get_element_commits(
            self,
            project_id,
            ref_id,
            element_id,
            **kwargs
        ):
            """get_element_commits  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_element_commits(project_id, ref_id, element_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str):
                ref_id (str):
                element_id (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommitsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['ref_id'] = \
                ref_id
            kwargs['element_id'] = \
                element_id
            return self.call_with_http_info(**kwargs)

        self.get_element_commits = _Endpoint(
            settings={
                'response_type': (CommitsResponse,),
                'auth': [
                    'basicAuth',
                    'bearerToken'
                ],
                'endpoint_path': '/projects/{projectId}/refs/{refId}/elements/{elementId}/commits',
                'operation_id': 'get_element_commits',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'ref_id',
                    'element_id',
                ],
                'required': [
                    'project_id',
                    'ref_id',
                    'element_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'ref_id':
                        (str,),
                    'element_id':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'ref_id': 'refId',
                    'element_id': 'elementId',
                },
                'location_map': {
                    'project_id': 'path',
                    'ref_id': 'path',
                    'element_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_element_commits
        )

        def __get_ref_commits(
            self,
            project_id,
            ref_id,
            **kwargs
        ):
            """get_ref_commits  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_ref_commits(project_id, ref_id, async_req=True)
            >>> result = thread.get()

            Args:
                project_id (str):
                ref_id (str):

            Keyword Args:
                limit (str): [optional]
                max_timestamp (str): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CommitsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['project_id'] = \
                project_id
            kwargs['ref_id'] = \
                ref_id
            return self.call_with_http_info(**kwargs)

        self.get_ref_commits = _Endpoint(
            settings={
                'response_type': (CommitsResponse,),
                'auth': [
                    'basicAuth',
                    'bearerToken'
                ],
                'endpoint_path': '/projects/{projectId}/refs/{refId}/commits',
                'operation_id': 'get_ref_commits',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'project_id',
                    'ref_id',
                    'limit',
                    'max_timestamp',
                ],
                'required': [
                    'project_id',
                    'ref_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'project_id':
                        (str,),
                    'ref_id':
                        (str,),
                    'limit':
                        (str,),
                    'max_timestamp':
                        (str,),
                },
                'attribute_map': {
                    'project_id': 'projectId',
                    'ref_id': 'refId',
                    'limit': 'limit',
                    'max_timestamp': 'maxTimestamp',
                },
                'location_map': {
                    'project_id': 'path',
                    'ref_id': 'path',
                    'limit': 'query',
                    'max_timestamp': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_ref_commits
        )
