from moco import CommandLineInterface, Command, Parser, opt


class CommandHello(Command):

    description = 'Hello world.'

    def execute(self, words):
        print('Hello, this is a command!')


class CommandParse(Command):

    description = 'Parse options and arguments.'

    parser = Parser([
        opt('--host', description='Server\'s hostname.'),
        opt('--port', description='Server\'s port number.'),
        opt('--username', alias=['-u'], description='Login username.'),
        opt('--password', alias=['-P'], description='Login password.'),
    ])

    def execute(self, words):
        if '-h' in words or '--help' in words or len(words) == 0:
            print(self.help(), end='')
            return
        args, opts = self.parser.parse(words)
        print(args)
        print(opts)


class MyCli(CommandLineInterface):

    description = 'An example Moco CLI program.'

    extend = {
        'hello': CommandHello,
        'parse': CommandParse,
    }

    def execute(self, words):
        if '-h' in words or '--help' in words or len(words) == 0:
            print(self.help(), end='')
            return


if __name__ == '__main__':
    my_cli = MyCli()
    my_cli.launch()
