"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EnableMethodIssuerRequestBodyTypedDict(TypedDict):
    contract_id: NotRequired[Nullable[str]]
    r"""When enabling a voucher issuer, an inbetween party may be involved which you have a contract with. Provide the contract ID for the first time you enable an issuer via this contractor.

    You can update the contract ID as long as it is not approved yet, by repeating the API call with a different contract ID.
    """


class EnableMethodIssuerRequestBody(BaseModel):
    contract_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="contractId")
    ] = UNSET
    r"""When enabling a voucher issuer, an inbetween party may be involved which you have a contract with. Provide the contract ID for the first time you enable an issuer via this contractor.

    You can update the contract ID as long as it is not approved yet, by repeating the API call with a different contract ID.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["contractId"]
        nullable_fields = ["contractId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EnableMethodIssuerRequestTypedDict(TypedDict):
    profile_id: str
    r"""Provide the ID of the related profile."""
    method_id: str
    r"""Provide the ID of the related payment method."""
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: NotRequired[EnableMethodIssuerRequestBodyTypedDict]


class EnableMethodIssuerRequest(BaseModel):
    profile_id: Annotated[
        str,
        pydantic.Field(alias="profileId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related profile."""

    method_id: Annotated[
        str,
        pydantic.Field(alias="methodId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment method."""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        Optional[EnableMethodIssuerRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class EnableMethodIssuerMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class EnableMethodIssuerMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class EnableMethodIssuerMethodsLinksTypedDict(TypedDict):
    documentation: NotRequired[EnableMethodIssuerMethodsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class EnableMethodIssuerMethodsLinks(BaseModel):
    documentation: Optional[EnableMethodIssuerMethodsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class EnableMethodIssuerMethodsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[EnableMethodIssuerMethodsLinks], pydantic.Field(alias="_links")
    ] = None


class EnableMethodIssuerMethodsResponseBody(Exception):
    r"""An error response object."""

    data: EnableMethodIssuerMethodsResponseBodyData

    def __init__(self, data: EnableMethodIssuerMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, EnableMethodIssuerMethodsResponseBodyData)


class ContractorTypedDict(TypedDict):
    r"""Information regarding the *contractor*. Only relevant for `voucher` issuers."""

    id: NotRequired[str]
    name: NotRequired[str]
    contract_id: NotRequired[str]


class Contractor(BaseModel):
    r"""Information regarding the *contractor*. Only relevant for `voucher` issuers."""

    id: Optional[str] = None

    name: Optional[str] = None

    contract_id: Annotated[Optional[str], pydantic.Field(alias="contractId")] = None


class EnableMethodIssuerImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method issuer."""

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class EnableMethodIssuerImage(BaseModel):
    r"""URLs of images representing the payment method issuer."""

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can scale to any desired size without compromising visual quality."""


class EnableMethodIssuerSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodIssuerSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodIssuerDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodIssuerDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class EnableMethodIssuerLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[EnableMethodIssuerSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[EnableMethodIssuerDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EnableMethodIssuerLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[EnableMethodIssuerSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[EnableMethodIssuerDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EnableMethodIssuerResponseBodyTypedDict(TypedDict):
    r"""The payment method issuer object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a payment method issuer object. Will always contain the string `issuer` for this endpoint."""
    id: NotRequired[str]
    r"""The unique identifier of the payment method issuer."""
    description: NotRequired[str]
    r"""The full name of the payment method issuer."""
    contractor: NotRequired[ContractorTypedDict]
    r"""Information regarding the *contractor*. Only relevant for `voucher` issuers."""
    status: NotRequired[Nullable[str]]
    r"""The status of the issuer. Only relevant for `voucher` issuers.

    If the status is `pending-issuer`, an additional action from your side may be required with the issuer.

    Possible values: `activated` `pending-issuer`
    """
    image: NotRequired[EnableMethodIssuerImageTypedDict]
    r"""URLs of images representing the payment method issuer."""
    links: NotRequired[EnableMethodIssuerLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EnableMethodIssuerResponseBody(BaseModel):
    r"""The payment method issuer object."""

    resource: Optional[str] = "issuer"
    r"""Indicates the response contains a payment method issuer object. Will always contain the string `issuer` for this endpoint."""

    id: Optional[str] = None
    r"""The unique identifier of the payment method issuer."""

    description: Optional[str] = None
    r"""The full name of the payment method issuer."""

    contractor: Optional[Contractor] = None
    r"""Information regarding the *contractor*. Only relevant for `voucher` issuers."""

    status: OptionalNullable[str] = UNSET
    r"""The status of the issuer. Only relevant for `voucher` issuers.

    If the status is `pending-issuer`, an additional action from your side may be required with the issuer.

    Possible values: `activated` `pending-issuer`
    """

    image: Optional[EnableMethodIssuerImage] = None
    r"""URLs of images representing the payment method issuer."""

    links: Annotated[
        Optional[EnableMethodIssuerLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "description",
            "contractor",
            "status",
            "image",
            "_links",
        ]
        nullable_fields = ["status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
