"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ReleaseAuthorizationRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ReleaseAuthorizationRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ReleaseAuthorizationPaymentsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ReleaseAuthorizationPaymentsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ReleaseAuthorizationPaymentsLinksTypedDict(TypedDict):
    documentation: NotRequired[ReleaseAuthorizationPaymentsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationPaymentsLinks(BaseModel):
    documentation: Optional[ReleaseAuthorizationPaymentsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationPaymentsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ReleaseAuthorizationPaymentsLinks], pydantic.Field(alias="_links")
    ] = None


class ReleaseAuthorizationPaymentsResponseBody(Exception):
    r"""An error response object."""

    data: ReleaseAuthorizationPaymentsResponseBodyData

    def __init__(self, data: ReleaseAuthorizationPaymentsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, ReleaseAuthorizationPaymentsResponseBodyData
        )


class ReleaseAuthorizationDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ReleaseAuthorizationDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ReleaseAuthorizationLinksTypedDict(TypedDict):
    documentation: NotRequired[ReleaseAuthorizationDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationLinks(BaseModel):
    documentation: Optional[ReleaseAuthorizationDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ReleaseAuthorizationResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ReleaseAuthorizationLinks], pydantic.Field(alias="_links")
    ] = None


class ReleaseAuthorizationResponseBody(Exception):
    r"""An error response object."""

    data: ReleaseAuthorizationResponseBodyData

    def __init__(self, data: ReleaseAuthorizationResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ReleaseAuthorizationResponseBodyData)
