"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import BaseModel, OptionalNullable, UNSET
from mollie_api_python_alpha.utils import FieldMetadata, PathParamMetadata
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class DeleteProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class DeleteProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class DeleteProfileProfilesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class DeleteProfileProfilesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class DeleteProfileProfilesLinksTypedDict(TypedDict):
    documentation: NotRequired[DeleteProfileProfilesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileProfilesLinks(BaseModel):
    documentation: Optional[DeleteProfileProfilesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileProfilesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[DeleteProfileProfilesLinks], pydantic.Field(alias="_links")
    ] = None


class DeleteProfileProfilesResponseBody(Exception):
    r"""An error response object."""

    data: DeleteProfileProfilesResponseBodyData

    def __init__(self, data: DeleteProfileProfilesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, DeleteProfileProfilesResponseBodyData)


class DeleteProfileDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class DeleteProfileDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class DeleteProfileLinksTypedDict(TypedDict):
    documentation: NotRequired[DeleteProfileDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileLinks(BaseModel):
    documentation: Optional[DeleteProfileDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class DeleteProfileResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[DeleteProfileLinks], pydantic.Field(alias="_links")] = (
        None
    )


class DeleteProfileResponseBody(Exception):
    r"""An error response object."""

    data: DeleteProfileResponseBodyData

    def __init__(self, data: DeleteProfileResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, DeleteProfileResponseBodyData)
