"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import (
    FieldMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetBalanceReportRequestTypedDict(TypedDict):
    balance_id: str
    r"""Provide the ID of the related balance."""
    from_: str
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will include transactions from 2024-01-01 0:00:00 CET and onwards."""
    until: str
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time. This means a report with for example `until=2024-02-01` will include transactions up until 2024-01-31 23:59:59 CET."""
    grouping: NotRequired[Nullable[str]]
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by status, and then again by other sub-groupings where available.

    Possible values: `status-balances` `transaction-categories` (default: `status-balances`)
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetBalanceReportRequest(BaseModel):
    balance_id: Annotated[
        str,
        pydantic.Field(alias="balanceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related balance."""

    from_: Annotated[
        str,
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will include transactions from 2024-01-01 0:00:00 CET and onwards."""

    until: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time. This means a report with for example `until=2024-02-01` will include transactions up until 2024-01-31 23:59:59 CET."""

    grouping: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by status, and then again by other sub-groupings where available.

    Possible values: `status-balances` `transaction-categories` (default: `status-balances`)
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["grouping", "testmode"]
        nullable_fields = ["grouping", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceReportBalancesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetBalanceReportBalancesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetBalanceReportBalancesLinksTypedDict(TypedDict):
    documentation: NotRequired[GetBalanceReportBalancesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceReportBalancesLinks(BaseModel):
    documentation: Optional[GetBalanceReportBalancesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceReportBalancesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetBalanceReportBalancesLinks], pydantic.Field(alias="_links")
    ] = None


class GetBalanceReportBalancesResponseBody(Exception):
    r"""An error response object."""

    data: GetBalanceReportBalancesResponseBodyData

    def __init__(self, data: GetBalanceReportBalancesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetBalanceReportBalancesResponseBodyData)


class TotalsTypedDict(TypedDict):
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments` or `refunds`, each containing a `pending`, `movedToAvailable`, and `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """


class Totals(BaseModel):
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments` or `refunds`, each containing a `pending`, `movedToAvailable`, and `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """


class GetBalanceReportSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetBalanceReportSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetBalanceReportDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceReportLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetBalanceReportSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetBalanceReportDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceReportResponseBodyTypedDict(TypedDict):
    r"""The balance report object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a balance report object. Will always contain the string `balance-report` for this endpoint."""
    balance_id: NotRequired[str]
    r"""The ID of the balance this report is generated for."""
    time_zone: NotRequired[str]
    r"""The time zone used for the from and until parameters. Currently only time zone `Europe/Amsterdam` is supported."""
    from_: NotRequired[str]
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will include movements of 2024-01-01 0:00:00 CET and onwards."""
    until: NotRequired[str]
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time. This means a report with for example `until=2024-02-01` will include movements up until 2024-01-31 23:59:59 CET."""
    grouping: NotRequired[str]
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by status (e.g. `pending`, `available`), then by direction of movement (e.g. moved from pending to available), then by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by direction of movement, and then again by other sub-groupings where available.

    Both reporting formats will always contain opening and closing amounts that correspond to the start and end dates of the report.

    Possible values: `status-balances` `transaction-categories` (default: `status-balances`)
    """
    totals: NotRequired[TotalsTypedDict]
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments` or `refunds`, each containing a `pending`, `movedToAvailable`, and `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """
    links: NotRequired[GetBalanceReportLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetBalanceReportResponseBody(BaseModel):
    r"""The balance report object."""

    resource: Optional[str] = "balance-report"
    r"""Indicates the response contains a balance report object. Will always contain the string `balance-report` for this endpoint."""

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None
    r"""The ID of the balance this report is generated for."""

    time_zone: Annotated[Optional[str], pydantic.Field(alias="timeZone")] = None
    r"""The time zone used for the from and until parameters. Currently only time zone `Europe/Amsterdam` is supported."""

    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will include movements of 2024-01-01 0:00:00 CET and onwards."""

    until: Optional[str] = None
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time. This means a report with for example `until=2024-02-01` will include movements up until 2024-01-31 23:59:59 CET."""

    grouping: Optional[str] = None
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by status (e.g. `pending`, `available`), then by direction of movement (e.g. moved from pending to available), then by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by direction of movement, and then again by other sub-groupings where available.

    Both reporting formats will always contain opening and closing amounts that correspond to the start and end dates of the report.

    Possible values: `status-balances` `transaction-categories` (default: `status-balances`)
    """

    totals: Optional[Totals] = None
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments` or `refunds`, each containing a `pending`, `movedToAvailable`, and `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    links: Annotated[
        Optional[GetBalanceReportLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
