"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie_api_python_alpha import utils
from mollie_api_python_alpha.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from mollie_api_python_alpha.utils import FieldMetadata, PathParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetSettlementRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""


class GetSettlementRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""


class GetSettlementSettlementsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class GetSettlementSettlementsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class GetSettlementSettlementsLinksTypedDict(TypedDict):
    documentation: NotRequired[GetSettlementSettlementsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementSettlementsLinks(BaseModel):
    documentation: Optional[GetSettlementSettlementsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementSettlementsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[GetSettlementSettlementsLinks], pydantic.Field(alias="_links")
    ] = None


class GetSettlementSettlementsResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementSettlementsResponseBodyData

    def __init__(self, data: GetSettlementSettlementsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, GetSettlementSettlementsResponseBodyData)


class GetSettlementAmountTypedDict(TypedDict):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementAmount(BaseModel):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PeriodsTypedDict(TypedDict):
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`.

    Each period object will contain the following fields:
    * `revenue` — An array of revenue objects containing the total revenue for each payment method during this period
    * `costs` — An array of cost objects, describing the fees withheld for each payment method during this period
    * `invoiceId` — The ID of the invoice created for this period, if the invoice has been created yet

    Each `revenue` object has the following fields:
    * `description` — A description of the revenue subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of payments
    * `amountNet` — The net total of received funds, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total of received funds, i.e. including VAT

    Each `cost` object has the following fields:
    * `description` — A description of the cost subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of fees
    * `rate` — The service rates, further divided into `fixed` and `percentage` costs
    * `amountNet` — The net total cost, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total cost, i.e. including VAT

    The example response should give a good idea of what this looks like in practise.
    """


class Periods(BaseModel):
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`.

    Each period object will contain the following fields:
    * `revenue` — An array of revenue objects containing the total revenue for each payment method during this period
    * `costs` — An array of cost objects, describing the fees withheld for each payment method during this period
    * `invoiceId` — The ID of the invoice created for this period, if the invoice has been created yet

    Each `revenue` object has the following fields:
    * `description` — A description of the revenue subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of payments
    * `amountNet` — The net total of received funds, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total of received funds, i.e. including VAT

    Each `cost` object has the following fields:
    * `description` — A description of the cost subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of fees
    * `rate` — The service rates, further divided into `fixed` and `percentage` costs
    * `amountNet` — The net total cost, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total cost, i.e. including VAT

    The example response should give a good idea of what this looks like in practise.
    """


class GetSettlementSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesTypedDict(TypedDict):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCaptures(BaseModel):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefundsTypedDict(TypedDict):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementRefunds(BaseModel):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementChargebacks(BaseModel):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[GetSettlementPaymentsTypedDict]
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""
    captures: NotRequired[GetSettlementCapturesTypedDict]
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""
    refunds: NotRequired[GetSettlementRefundsTypedDict]
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""
    chargebacks: NotRequired[GetSettlementChargebacksTypedDict]
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""
    documentation: NotRequired[GetSettlementDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetSettlementSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: Optional[GetSettlementPayments] = None
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    captures: Optional[GetSettlementCaptures] = None
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    refunds: Optional[GetSettlementRefunds] = None
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    chargebacks: Optional[GetSettlementChargebacks] = None
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    documentation: Optional[GetSettlementDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementResponseBodyTypedDict(TypedDict):
    r"""The settlement object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this settlement. Example: `stl_jDk30akdN`."""
    reference: NotRequired[str]
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""
    settled_at: NotRequired[Nullable[str]]
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement date is available.
    """
    status: NotRequired[str]
    r"""The status of the settlement.

    * `open` — The settlement has not been closed yet
    * `pending` — The settlement has been closed and is being processed
    * `paidout` — The settlement has been paid out
    * `failed` — The settlement could not be paid out

    Possible values: `open` `pending` `paidout` `failed`
    """
    amount: NotRequired[GetSettlementAmountTypedDict]
    r"""The total amount of the settlement."""
    balance_id: NotRequired[str]
    r"""The balance token that the settlement was settled to."""
    periods: NotRequired[PeriodsTypedDict]
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`.

    Each period object will contain the following fields:
    * `revenue` — An array of revenue objects containing the total revenue for each payment method during this period
    * `costs` — An array of cost objects, describing the fees withheld for each payment method during this period
    * `invoiceId` — The ID of the invoice created for this period, if the invoice has been created yet

    Each `revenue` object has the following fields:
    * `description` — A description of the revenue subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of payments
    * `amountNet` — The net total of received funds, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total of received funds, i.e. including VAT

    Each `cost` object has the following fields:
    * `description` — A description of the cost subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of fees
    * `rate` — The service rates, further divided into `fixed` and `percentage` costs
    * `amountNet` — The net total cost, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total cost, i.e. including VAT

    The example response should give a good idea of what this looks like in practise.
    """
    links: NotRequired[GetSettlementLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetSettlementResponseBody(BaseModel):
    r"""The settlement object."""

    resource: Optional[str] = "settlement"
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this settlement. Example: `stl_jDk30akdN`."""

    reference: Optional[str] = None
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""

    settled_at: Annotated[OptionalNullable[str], pydantic.Field(alias="settledAt")] = (
        UNSET
    )
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement date is available.
    """

    status: Optional[str] = None
    r"""The status of the settlement.

    * `open` — The settlement has not been closed yet
    * `pending` — The settlement has been closed and is being processed
    * `paidout` — The settlement has been paid out
    * `failed` — The settlement could not be paid out

    Possible values: `open` `pending` `paidout` `failed`
    """

    amount: Optional[GetSettlementAmount] = None
    r"""The total amount of the settlement."""

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None
    r"""The balance token that the settlement was settled to."""

    periods: Optional[Periods] = None
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`.

    Each period object will contain the following fields:
    * `revenue` — An array of revenue objects containing the total revenue for each payment method during this period
    * `costs` — An array of cost objects, describing the fees withheld for each payment method during this period
    * `invoiceId` — The ID of the invoice created for this period, if the invoice has been created yet

    Each `revenue` object has the following fields:
    * `description` — A description of the revenue subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of payments
    * `amountNet` — The net total of received funds, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total of received funds, i.e. including VAT

    Each `cost` object has the following fields:
    * `description` — A description of the cost subtotal
    * `method` — The payment method, if applicable
    * `count` — The number of fees
    * `rate` — The service rates, further divided into `fixed` and `percentage` costs
    * `amountNet` — The net total cost, i.e. excluding VAT
    * `amountVat` — The applicable VAT
    * `amountGross` — The gross total cost, i.e. including VAT

    The example response should give a good idea of what this looks like in practise.
    """

    links: Annotated[Optional[GetSettlementLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "reference",
            "settledAt",
            "status",
            "amount",
            "balanceId",
            "periods",
            "_links",
        ]
        nullable_fields = ["settledAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
